/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.patterns;

import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.trees.constraints.After;
import org.gcube.data.trees.constraints.AfterDate;
import org.gcube.data.trees.constraints.All;
import org.gcube.data.trees.constraints.AnyValue;
import org.gcube.data.trees.constraints.Before;
import org.gcube.data.trees.constraints.BeforeDate;
import org.gcube.data.trees.constraints.Constraint;
import org.gcube.data.trees.constraints.Either;
import org.gcube.data.trees.constraints.Less;
import org.gcube.data.trees.constraints.Match;
import org.gcube.data.trees.constraints.More;
import org.gcube.data.trees.constraints.Not;
import org.gcube.data.trees.constraints.Same;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.patterns.AbstractPattern;
import org.gcube.data.trees.patterns.URIPattern;

@XmlRootElement
public abstract class LeafPattern<T, C extends Constraint<? super T>>
extends AbstractPattern {
    private static final long serialVersionUID = 1L;
    @XmlElementRefs(value={@XmlElementRef(type=AnyValue.class), @XmlElementRef(type=All.class), @XmlElementRef(type=Either.class), @XmlElementRef(type=Not.class), @XmlElementRef(type=Same.class), @XmlElementRef(type=More.class), @XmlElementRef(type=Less.class), @XmlElementRef(type=URIPattern.class), @XmlElementRef(type=BeforeDate.class), @XmlElementRef(type=AfterDate.class), @XmlElementRef(type=Before.class), @XmlElementRef(type=After.class), @XmlElementRef(type=Match.class)})
    protected C constraint;

    LeafPattern() {
    }

    public LeafPattern(C c) {
        this.constraint = c;
    }

    @Override
    public final void prune(Node n) throws Exception {
        super.prune(n);
        try {
            Leaf l = (Leaf)n;
            if (!this.matches(n)) {
                throw new Exception("value " + l.value() + " does not match " + this);
            }
        }
        catch (ClassCastException e) {
            throw new Exception(this + " found an unexpected tree");
        }
    }

    public C constraint() {
        return this.constraint;
    }

    @Override
    public boolean matches(Node n) {
        if (!super.matches(n)) {
            return false;
        }
        try {
            Leaf l = (Leaf)n;
            T val = this.valueOf(l.value());
            return this.constraint.accepts(val);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract T valueOf(String var1) throws Exception;

    public abstract String name();

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[ ");
        if (this.idPattern() != null) {
            b.append("(id:" + this.idPattern() + ") ");
        }
        b.append(this.name() + " is " + this.constraint.toString());
        b.append("]");
        return b.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.constraint == null ? 0 : this.constraint.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeafPattern other = (LeafPattern)obj;
        return !(this.constraint == null ? other.constraint != null : !this.constraint.equals(other.constraint));
    }
}

