/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.data;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;

public class Nodes {
    public static final Class<Leaf> L = Leaf.class;
    public static final Class<InnerNode> N = InnerNode.class;
    private static DatatypeFactory typeFactory;

    public static QName q(String name) {
        return new QName(name);
    }

    public static QName q(String ns, String name) {
        return new QName(ns, name);
    }

    public static QName q(String prefix, String ns, String name) {
        return new QName(prefix, ns, name);
    }

    public static Tree t(Tree root) {
        return new Tree(root);
    }

    public static Tree t(String collID, String id, Edge ... edges) {
        return new Tree(collID, id, edges);
    }

    public static Tree t(String id, Edge ... edges) {
        return new Tree(id, edges);
    }

    public static Tree t(Edge ... edges) {
        return Nodes.t(null, edges);
    }

    public static InnerNode n(InnerNode n) {
        return new InnerNode(n);
    }

    public static InnerNode n(String id, Edge ... es) {
        return new InnerNode(id, es);
    }

    public static InnerNode n(Edge ... es) {
        return Nodes.n(null, es);
    }

    public static Edge e(Edge e) {
        return new Edge(e);
    }

    public static Edge e(QName name, Node node) {
        return new Edge(name, node);
    }

    public static Edge e(String name, Node node) {
        return Nodes.e(Nodes.q(name), node);
    }

    public static Edge e(QName name, Object v) {
        return Nodes.e(name, (Node)Nodes.l(v));
    }

    public static Edge e(String name, Object v) {
        return Nodes.e(Nodes.q(name), (Node)Nodes.l(v));
    }

    public static Leaf l(Leaf l) {
        return new Leaf(l);
    }

    public static Leaf l(String id, Object v) {
        return new Leaf(id, Nodes.toString(v));
    }

    public static Leaf l(Object v) {
        return Nodes.l(null, v);
    }

    public static <N extends Node> N attr(N n, Attribute attribute, Attribute ... attributes) {
        n.setAttribute(attribute.name, attribute.value);
        for (Attribute att : attributes) {
            n.setAttribute(att.name, att.value);
        }
        return n;
    }

    public static Attribute a(String name, Object v) throws IllegalArgumentException {
        return Nodes.a(Nodes.q(name), v);
    }

    public static Attribute a(QName name, Object v) {
        Attribute a = new Attribute();
        a.name = name;
        a.value = Nodes.toString(v);
        return a;
    }

    private static String toString(Object v) {
        return v instanceof Date ? Nodes.toDateString((Date)v) : (v instanceof Calendar ? Nodes.toDateString(((Calendar)v).getTime()) : String.valueOf(v));
    }

    public static synchronized String toDateString(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return typeFactory.newXMLGregorianCalendar(c).toString();
    }

    public static synchronized Date toDate(String date) throws IllegalArgumentException {
        return typeFactory.newXMLGregorianCalendar(date.trim()).toGregorianCalendar().getTime();
    }

    public static boolean matches(QName lbl, QName regexp) {
        return lbl.getNamespaceURI().matches(regexp.getNamespaceURI()) && lbl.getLocalPart().matches(regexp.getLocalPart());
    }

    static {
        try {
            typeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("could not configure datatype factory", e);
        }
    }

    public static class Attribute {
        public QName name;
        public String value;
    }
}

