/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.common.uri.Mint;
import org.gcube.common.uri.MintProvider;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Tree;

public abstract class Node {
    private String id;
    private Map<QName, String> attributes;
    private State state;
    private InnerNode parent;

    public Node() {
    }

    protected Node(String id) {
        this(id, null, null);
    }

    public abstract long size();

    protected Node(String i, State s, Map<QName, String> as) {
        this.id = i;
        this.state = s;
        this.attributes = as == null ? new HashMap() : as;
    }

    public String id() {
        return this.id;
    }

    public synchronized Map<QName, String> attributes() {
        return new HashMap<QName, String>(this.attributes);
    }

    public synchronized String setAttribute(QName name, String value) {
        return this.attributes.put(name, value);
    }

    public synchronized String setAttribute(String name, String value) throws IllegalArgumentException {
        return this.setAttribute(new QName(name), value);
    }

    public synchronized String removeAttribute(QName name) {
        if (this.hasAttribute(name)) {
            return this.attributes.remove(name);
        }
        throw new IllegalStateException("unknown attribute " + name);
    }

    public synchronized String removeAttribute(String name) throws IllegalStateException, IllegalArgumentException {
        return this.removeAttribute(new QName(name));
    }

    public synchronized String attribute(QName name) throws IllegalStateException {
        if (this.hasAttribute(name)) {
            return this.attributes.get(name);
        }
        throw new IllegalStateException("unknown attribute " + name);
    }

    public synchronized String attribute(String name) throws IllegalStateException, IllegalArgumentException {
        return this.attribute(new QName(name));
    }

    public synchronized boolean hasAttribute(QName name) {
        return this.attributes().containsKey(name);
    }

    public synchronized boolean hasAttribute(String name) throws IllegalArgumentException {
        return this.hasAttribute(new QName(name));
    }

    public synchronized State state() {
        return this.state;
    }

    protected synchronized void state(State s) {
        this.state = s;
    }

    public void delete() {
        this.state = State.DELETED;
        this.attributes.clear();
    }

    public void update(Node delta) throws IllegalStateException, IllegalArgumentException {
        if (this.id() == null) {
            throw new IllegalStateException("new nodes cannot be updated");
        }
        if (!this.id().equals(delta.id())) {
            throw new IllegalArgumentException("delta node's identifier (" + delta.id + ") does not mach this node's (" + this.id() + ")");
        }
        if (delta.state() == State.NEW) {
            throw new IllegalArgumentException("delta node is invalid state " + (Object)((Object)delta.state()));
        }
        if (delta.state() == State.DELETED) {
            this.delete();
            return;
        }
        Map<QName, String> attributes = this.attributes();
        for (Map.Entry<QName, String> dAttribute : delta.attributes().entrySet()) {
            String value = attributes.get(dAttribute.getKey());
            if (value == null) {
                this.setAttribute(dAttribute.getKey(), dAttribute.getValue());
                continue;
            }
            if (dAttribute.getValue() == null) {
                this.removeAttribute(dAttribute.getKey());
                continue;
            }
            this.setAttribute(dAttribute.getKey(), dAttribute.getValue());
        }
    }

    protected synchronized Node delta(Node future) throws IllegalStateException, IllegalArgumentException {
        if (this.id() == null) {
            throw new IllegalStateException("new nodes cannot be updated");
        }
        if (!this.getClass().isInstance(future)) {
            throw new IllegalArgumentException("node mismatch:expected a " + this.getClass().getSimpleName() + ", found a " + future.getClass().getSimpleName());
        }
        if (!this.id().equals(future.id())) {
            throw new IllegalArgumentException("identifier mismatch: expected " + this.id() + ", found " + future.id());
        }
        Node delta = null;
        try {
            delta = (Node)this.getClass().getConstructor(String.class).newInstance(this.id);
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected problem invoking node constructor reflectively", e);
        }
        Map<QName, String> copy = future.attributes();
        for (Map.Entry<QName, String> attribute : this.attributes().entrySet()) {
            String futureVal = copy.remove(attribute.getKey());
            if (futureVal == null) {
                delta.setAttribute(attribute.getKey(), null);
                delta.state(State.MODIFIED);
                continue;
            }
            if (futureVal.equals(attribute.getValue())) continue;
            delta.setAttribute(attribute.getKey(), futureVal);
            copy.remove(attribute.getKey());
            delta.state(State.MODIFIED);
        }
        for (Map.Entry<QName, String> nweAttribute : copy.entrySet()) {
            delta.setAttribute(nweAttribute.getKey(), nweAttribute.getValue());
            delta.state(State.MODIFIED);
        }
        return delta;
    }

    protected void setParent(InnerNode p) {
        this.parent = p;
    }

    public InnerNode parent() {
        return this.parent;
    }

    public synchronized List<InnerNode> ancestors() {
        ArrayList<InnerNode> ancestors = new ArrayList<InnerNode>();
        Node current = this;
        while (current.parent() != null) {
            ancestors.add(current.parent());
            current = current.parent();
        }
        return ancestors;
    }

    public synchronized List<Node> ancestorsAndSelf() {
        ArrayList<Node> ancestors = new ArrayList<Node>(this.ancestors());
        ancestors.add((InnerNode)this);
        return ancestors;
    }

    public URI uri() throws IllegalStateException {
        return this.uri(MintProvider.mint());
    }

    public URI uri(Mint mint) throws IllegalStateException {
        if (this.id() == null) {
            throw new IllegalStateException(this + " has no identifier");
        }
        Node last = null;
        ArrayList<String> path = new ArrayList<String>();
        for (Node child = this; child != null; child = child.parent()) {
            if (child.id() == null) {
                throw new IllegalStateException(child + " has no identifier");
            }
            path.add(child.id());
            last = child;
        }
        String sourceId = ((Tree)last).sourceId();
        if (sourceId == null) {
            throw new IllegalStateException(last + " has not source identifier");
        }
        path.add(sourceId);
        Collections.reverse(path);
        ArrayList<String> fullPath = new ArrayList<String>();
        fullPath.add("tree");
        fullPath.addAll(path);
        return mint.mint(fullPath);
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof Node)) {
            return false;
        }
        Node node = (Node)obj;
        return (this.id() == null ? node.id() == null : this.id().equals(node.id())) && (this.state() == null || this.state().equals((Object)node.state())) && ((Object)this.attributes()).equals(node.attributes());
    }

    public int hashCode() {
        return this.state == null ? 0 : this.state.hashCode() + 31 * (this.id == null ? 0 : this.id.hashCode() + 31 * (((Object)this.attributes).hashCode() + 527));
    }

    public static enum State {
        NEW,
        MODIFIED,
        DELETED;

    }
}

