/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.patterns;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.patterns.AbstractPattern;
import org.gcube.data.trees.patterns.AtLeastPattern;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.ManyPattern;
import org.gcube.data.trees.patterns.OnePattern;
import org.gcube.data.trees.patterns.OnlyPattern;
import org.gcube.data.trees.patterns.OptPattern;

@XmlRootElement(name="t")
@XmlType(propOrder={"patterns"})
public class TreePattern
extends AbstractPattern {
    private static final long serialVersionUID = 1L;
    @XmlElementRefs(value={@XmlElementRef(type=OnePattern.class), @XmlElementRef(type=ManyPattern.class), @XmlElementRef(type=OnlyPattern.class), @XmlElementRef(type=AtLeastPattern.class), @XmlElementRef(type=OptPattern.class)})
    List<EdgePattern> patterns = new ArrayList<EdgePattern>();

    TreePattern() {
    }

    public TreePattern(List<EdgePattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public boolean matches(Node n) {
        try {
            if (!super.matches(n)) {
                return false;
            }
            InnerNode node = (InnerNode)n;
            if (this.idPattern() != null && !this.idPattern().matches(Nodes.l(node.id()))) {
                return false;
            }
            List<Edge> unmatched = node.edges();
            for (EdgePattern ep : this.patterns) {
                List<Edge> candidates;
                if (!ep.matches(candidates = ep.matchLabels(unmatched))) {
                    return false;
                }
                unmatched.removeAll(candidates);
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @Override
    public void prune(Node n) throws Exception {
        try {
            super.prune(n);
            InnerNode node = (InnerNode)n;
            if (this.patterns.size() == 0) {
                return;
            }
            List<Edge> unmatched = node.edges();
            for (EdgePattern ep : this.patterns) {
                List<Edge> candidates = ep.matchLabels(unmatched);
                List<Edge> matched = ep.prune(candidates);
                if (ep.isCondition()) {
                    node.remove(matched);
                }
                unmatched.removeAll(matched);
            }
            node.remove(unmatched);
        }
        catch (ClassCastException e) {
            throw new Exception(this + " found an unexpected leaf " + n);
        }
    }

    public List<EdgePattern> patterns() {
        return this.patterns;
    }

    public EdgePattern pattern(QName label) {
        for (EdgePattern ep : this.patterns) {
            if (!ep.label().equals(label)) continue;
            return ep;
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[ ");
        if (this.idPattern() != null) {
            b.append("(id:" + this.idPattern() + ") ");
        }
        for (EdgePattern ep : this.patterns) {
            b.append("(" + ep + ") ");
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.patterns == null ? 0 : ((Object)this.patterns).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreePattern other = (TreePattern)obj;
        if (this.patterns == null) {
            return other.patterns == null;
        }
        HashSet<EdgePattern> s1 = new HashSet<EdgePattern>(this.patterns);
        HashSet<EdgePattern> s2 = new HashSet<EdgePattern>(((TreePattern)obj).patterns);
        return s1.equals(s2);
    }
}

