/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Bindings {
    private static final DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory tracFactory = TransformerFactory.newInstance();
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    public static final String ROOT_NAME = "root";
    public static final String PREFIX = "t";
    public static final String URI = "uri";
    public static final QName ROOT_QNAME;
    public static final String DEFAULT_NODE_NAME = "node";
    public static final QName NODE_QNAME;
    public static final String ID_ATTR = "id";
    public static final String STATUS_ATTR = "state";
    public static final String COLLID_ATTR = "collID";

    public static String toText(Tree t) throws Exception {
        StringWriter writer = new StringWriter();
        Bindings.toWriter(t, writer, new boolean[0]);
        return writer.toString();
    }

    public static void toWriter(Tree t, Writer stream, boolean ... writeDeclaration) throws Exception {
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(stream);
        Bindings.bind(t, writer);
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }

    public static Tree fromReader(Reader reader) throws Exception {
        XMLStreamReader r = inputFactory.createXMLStreamReader(reader);
        r.nextTag();
        r.require(1, "http://gcube-system.org/namespaces/data/trees", ROOT_NAME);
        return (Tree)Bindings.bindReader(ROOT_QNAME, r);
    }

    public static Tree fromStream(InputStream stream) throws Exception {
        return Bindings.fromReader(new InputStreamReader(stream));
    }

    public static Node nodeFromReader(Reader r) throws Exception {
        XMLStreamReader reader = inputFactory.createXMLStreamReader(r);
        reader.nextTag();
        return Bindings.bindReader(NODE_QNAME, reader);
    }

    public static Node nodeFromStream(InputStream in) throws Exception {
        return Bindings.nodeFromReader(new InputStreamReader(in));
    }

    public static Element toElement(Tree tree) throws Exception {
        InputSource source = new InputSource(new StringReader(Bindings.toText(tree)));
        return domFactory.newDocumentBuilder().parse(source).getDocumentElement();
    }

    public static Tree fromElement(Element element) throws Exception {
        if (element == null) {
            return null;
        }
        DOMSource source = new DOMSource(element);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        tracFactory.newTransformer().transform(source, result);
        return Bindings.fromReader(new StringReader(writer.toString()));
    }

    public static Node nodeFromElement(Element element) throws Exception {
        if (element == null) {
            return null;
        }
        DOMSource source = new DOMSource(element);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        tracFactory.newTransformer().transform(source, result);
        return Bindings.nodeFromReader(new StringReader(writer.toString()));
    }

    public static Element nodeToElement(Node node, QName ... name) throws Exception {
        StringWriter w = new StringWriter();
        Bindings.nodeToWriter(node, w, name);
        InputSource source = new InputSource(new StringReader(w.toString()));
        return domFactory.newDocumentBuilder().parse(source).getDocumentElement();
    }

    public static void nodeToWriter(Node node, Writer stream, QName ... name) throws Exception {
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(stream);
        writer.setPrefix(PREFIX, "http://gcube-system.org/namespaces/data/trees");
        QName qname = name.length == 0 ? NODE_QNAME : name[0];
        writer.writeStartDocument();
        if (node instanceof InnerNode) {
            Bindings.bindInner(qname, (InnerNode)node, writer);
        } else {
            Bindings.bindLeaf(qname, (Leaf)node, writer);
        }
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }

    private static void bind(Tree t, XMLStreamWriter writer) throws Exception {
        writer.writeStartDocument();
        writer.writeStartElement(PREFIX, ROOT_NAME, "http://gcube-system.org/namespaces/data/trees");
        writer.writeNamespace(PREFIX, "http://gcube-system.org/namespaces/data/trees");
        Bindings.bindNode(t, writer);
        if (t.sourceId() != null) {
            writer.writeAttribute(PREFIX, "http://gcube-system.org/namespaces/data/trees", COLLID_ATTR, t.sourceId());
        }
        for (Edge e : t.edges()) {
            if (e.target() instanceof InnerNode) {
                Bindings.bindInner(e.label(), (InnerNode)e.target(), writer);
                continue;
            }
            Leaf leaf = (Leaf)e.target();
            if (leaf.value() == null) {
                Bindings.bindEmptyLeaf(e.label(), leaf, writer);
                continue;
            }
            Bindings.bindLeaf(e.label(), leaf, writer);
        }
        writer.writeEndElement();
    }

    private static void bindNode(Node node, XMLStreamWriter writer) throws Exception {
        for (Map.Entry<QName, String> attr : node.attributes().entrySet()) {
            if (attr.getValue() == null) continue;
            String prefix = attr.getKey().getPrefix();
            String ns = attr.getKey().getNamespaceURI();
            String name = attr.getKey().getLocalPart();
            String value = attr.getValue();
            if (!prefix.isEmpty()) {
                writer.writeAttribute(prefix, ns, name, value);
                continue;
            }
            if (!ns.isEmpty()) {
                writer.writeAttribute(ns, name, value);
                continue;
            }
            writer.writeAttribute(name, value);
        }
        if (node.id() != null) {
            writer.writeAttribute(PREFIX, "http://gcube-system.org/namespaces/data/trees", ID_ATTR, node.id());
        }
        if (node.state() != null) {
            writer.writeAttribute(PREFIX, "http://gcube-system.org/namespaces/data/trees", STATUS_ATTR, node.state().name());
        }
    }

    private static void bindInner(QName label, InnerNode node, XMLStreamWriter writer) throws Exception {
        if (!label.getPrefix().isEmpty()) {
            writer.writeStartElement(label.getPrefix(), label.getLocalPart(), label.getNamespaceURI());
        } else if (!label.getNamespaceURI().isEmpty()) {
            writer.writeStartElement(label.getNamespaceURI(), label.getLocalPart());
        } else {
            writer.writeStartElement(label.getLocalPart());
        }
        Bindings.bindNode(node, writer);
        for (Edge e : node.edges()) {
            if (e.target() instanceof InnerNode) {
                Bindings.bindInner(e.label(), (InnerNode)e.target(), writer);
                continue;
            }
            Bindings.bindLeaf(e.label(), (Leaf)e.target(), writer);
        }
        writer.writeEndElement();
    }

    private static void bindLeaf(QName label, Leaf leaf, XMLStreamWriter writer) throws Exception {
        if (!label.getPrefix().isEmpty()) {
            writer.writeStartElement(label.getPrefix(), label.getLocalPart(), label.getNamespaceURI());
        } else if (!label.getNamespaceURI().isEmpty()) {
            writer.writeStartElement(label.getNamespaceURI(), label.getLocalPart());
        } else {
            writer.writeStartElement(label.getLocalPart());
        }
        Bindings.bindNode(leaf, writer);
        writer.writeCharacters(leaf.value());
        writer.writeEndElement();
    }

    private static void bindEmptyLeaf(QName label, Node leaf, XMLStreamWriter writer) throws Exception {
        if (!label.getPrefix().isEmpty()) {
            writer.writeEmptyElement(label.getPrefix(), label.getLocalPart(), label.getNamespaceURI());
        } else if (!label.getNamespaceURI().isEmpty()) {
            writer.writeEmptyElement(label.getNamespaceURI(), label.getLocalPart());
        } else {
            writer.writeEmptyElement(label.getLocalPart());
        }
        writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        Bindings.bindNode(leaf, writer);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Node bindReader(QName label, XMLStreamReader reader) throws Exception {
        String collectionId = null;
        String id = null;
        Node.State state = null;
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        String value = null;
        id = reader.getAttributeValue("http://gcube-system.org/namespaces/data/trees", ID_ATTR);
        collectionId = reader.getAttributeValue("http://gcube-system.org/namespaces/data/trees", COLLID_ATTR);
        String stringstate = reader.getAttributeValue("http://gcube-system.org/namespaces/data/trees", STATUS_ATTR);
        if (stringstate != null) {
            state = Node.State.valueOf(stringstate);
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String ns = reader.getAttributeNamespace(i);
            String name = reader.getAttributeLocalName(i);
            String prefix = reader.getAttributePrefix(i);
            if (ns != null && ns.equals("http://gcube-system.org/namespaces/data/trees")) continue;
            if (ns != null && ns.equals("http://www.w3.org/2001/XMLSchema-instance") && name.equals("nil") && reader.getAttributeValue(i).equals("true")) {
                value = "nil";
                break;
            }
            QName attribute = prefix == null ? new QName(ns, name, prefix) : new QName(ns, name);
            String attrValue = reader.getAttributeValue(i);
            attributes.put(attribute, attrValue);
        }
        block6: while (reader.hasNext()) {
            boolean leaf = false;
            boolean inner = false;
            int next = reader.next();
            switch (next) {
                case 1: {
                    if (leaf) {
                        throw new IllegalArgumentException("invalid tree serialisation: found mixed content");
                    }
                    inner = true;
                    QName edgeLabel = reader.getName();
                    edges.add(new Edge(edgeLabel, Bindings.bindReader(edgeLabel, reader)));
                    break;
                }
                case 4: {
                    if (inner) {
                        throw new IllegalArgumentException("invalid tree serialisation: found mixed content");
                    }
                    leaf = true;
                    value = reader.getText();
                    break;
                }
                case 2: {
                    break block6;
                }
            }
        }
        if (label.equals(ROOT_QNAME)) {
            Tree doc = new Tree(id, state, attributes, edges.toArray(new Edge[0]));
            doc.setSourceId(collectionId);
            return doc;
        }
        if (value == null) {
            return new InnerNode(id, state, attributes, edges.toArray(new Edge[0]));
        }
        if (value.equals("nil")) {
            value = null;
        }
        return new Leaf(id, state, value, attributes);
    }

    static {
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", new Boolean(true));
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        domFactory.setNamespaceAware(true);
        ROOT_QNAME = Nodes.q("http://gcube-system.org/namespaces/data/trees", ROOT_NAME);
        NODE_QNAME = Nodes.q("http://gcube-system.org/namespaces/data/trees", DEFAULT_NODE_NAME);
    }
}

