package org.gcube.data.analysis.statisticalmanager.persistence;

import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.operation.importer.FileManager;
import org.gcube.data.analysis.statisticalmanager.persistence.data.User;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class UserManager {

	private String userId;
	
	public String getUserId() {
		return userId;
	}

	private UserHistoryManager historyManager;
	private UserDataSpaceManager dataManager;
		
	public UserManager(String userLogin) throws StatisticalManagerException {
			
		Session session = PersistentHibernateManager.
		getSessionFactory().openSession();
		try {
			User user = (User)session.get(User.class, userLogin);
			if (user == null) {
				Transaction t = null;
				try {
					t = session.beginTransaction();
					user = new User(userLogin);
					session.save(user);
					session.getTransaction().commit();
				} catch (Exception e) {
					if (t != null) 
						t.rollback();
				}
			}
			this.userId = user.getUsername();
		} finally {
			session.close();
			if (userId == null) {
				throw new StatisticalManagerException("User doesn't initialize");
			}
		}
	}
	
	public UserHistoryManager getUserHistoryManager() {
		if (historyManager == null)
			historyManager = new UserHistoryManager(userId);
		return historyManager;
	}
	
	public UserDataSpaceManager getUserdaDataSpaceManager() {
		if (dataManager == null)
			dataManager = new UserDataSpaceManager(userId);
		return dataManager;
	}
	
	
}
