package org.gcube.data.analysis.statisticalmanager.porttypes;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.UUID;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.DataSpaceImporterContext;
import org.gcube.data.analysis.statisticalmanager.context.StatisticalManagerContext;
import org.gcube.data.analysis.statisticalmanager.db.DataSourceManager;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.home.StatisticalManagerDataSpaceImporterHome;
import org.gcube.data.analysis.statisticalmanager.home.StatisticalManagerServiceHome;
import org.gcube.data.analysis.statisticalmanager.persistence.UserDataSpaceManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserManager;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpacePortType;
import org.gcube.data.analysis.statisticalmanager.stubs.FactoryPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImportersRequest;
import org.gcube.data.analysis.statisticalmanager.wsresources.DataSpaceImporterResource;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerServiceResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.CSVtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.DataStreamtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.OperationInfo;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataRequest;

import antlr.Utils;

public class DataSpace extends GCUBEPortType implements DataSpacePortType{

	@Override
	protected ServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}
	

	@Override
	public EndpointReferenceType createTableFromCSV(CSVtoTabularRequest request)
			throws RemoteException, GCUBEFault {
		
		try {
			
			GCUBEStatefulPortTypeContext stfctx = DataSpaceImporterContext.getContext();  
			GCUBEWSResourceKey key = stfctx.makeKey(UUID.randomUUID().toString());               

			StatisticalManagerDataSpaceImporterHome home = (StatisticalManagerDataSpaceImporterHome)stfctx.getWSHome();
			DataSpaceImporterResource wsResource = (DataSpaceImporterResource)home.create(key, request.getUser());
			wsResource.createTableFromCSV(request);
			
			return wsResource.getEPR();
			
		} catch (Exception e) {
			throw new GCUBEUnrecoverableException(e).toFault();
		}
	}

	@Override
	public EndpointReferenceType createTableFromDataStream(DataStreamtoTabularRequest request)
			throws RemoteException, GCUBEFault {
		
	try {
			
			GCUBEStatefulPortTypeContext stfctx = DataSpaceImporterContext.getContext();  
			GCUBEWSResourceKey key = stfctx.makeKey(UUID.randomUUID().toString());               

			StatisticalManagerDataSpaceImporterHome home = (StatisticalManagerDataSpaceImporterHome)stfctx.getWSHome();
			DataSpaceImporterResource wsResource = (DataSpaceImporterResource)home.create(key, request.getUser());
			wsResource.createTableFromDataStream(request);
			
			return wsResource.getEPR();
			
		} catch (Exception e) {
			throw new GCUBEUnrecoverableException(e).toFault();
		}

	}

	@Override
	public String getDBParameters(String tableId) throws RemoteException,
			GCUBEFault {
			
		String url = DataSourceManager.getUrlDB() + 
		"?user="+ DataSourceManager.getUsername() +
		"&password=" + DataSourceManager.getPassword(); 
				
		return url;
		
	}

	@Override
	public SMTableMetadataList getTableMetadata(SMTableMetadataRequest request)
			throws RemoteException, GCUBEFault {

		try {
			
			logger.debug("Get table metadata called with request");
			logger.debug("user " + request.getUser());
			logger.debug("template " + request.getTemplate());
			
			UserDataSpaceManager userDataManager = new UserManager(request.getUser()).
			getUserdaDataSpaceManager();
			if (request.getTemplate() == null)
				return userDataManager.getTabularData();
			else 
				return userDataManager.getTabularDataByTemplate(request.getTemplate());
		} catch (StatisticalManagerException e) {
			throw new GCUBEUnrecoverableException(e).toFault();
		}
	}


	@Override
	public SMImporters getImporters(SMImportersRequest request)
			throws RemoteException, GCUBEFault {
		
		GCUBEStatefulPortTypeContext stfctx = DataSpaceImporterContext.getContext();  
		            
		ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
		StatisticalManagerDataSpaceImporterHome home = (StatisticalManagerDataSpaceImporterHome)stfctx.getWSHome();
		for (GCUBEWSResourceKey key : home.getIdentifiers()) {
			DataSpaceImporterResource importer = (DataSpaceImporterResource)home.find(key);
			if (importer != null) {
				
				try {
					if ((request.getUser() != null) && (request.getObjectType() != null)) {
						if ((importer.getObjectType().equals(request.getObjectType())) && 
								(importer.getUser().equals(request.getUser()))){
							eprs.add(importer.getEPR());
						}
					} else if (request.getUser() != null) {
						if (importer.getUser().equals(request.getUser())) {
							eprs.add(importer.getEPR());
						}
					} else if (request.getObjectType() != null) {
						
						if (importer.getObjectType().equals(request.getObjectType())) {
							eprs.add(importer.getEPR());
						}
					} else {
						eprs.add(importer.getEPR());
					}
						
						
				} catch (Exception e) {
					logger.error("EPR retrieval filed");
				}
			}
		}
		
		return new SMImporters(eprs.toArray(new EndpointReferenceType[eprs.size()]));
		
	}
	
}
