package org.gcube.data.analysis.statisticalmanager.porttypes;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;


import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.StatisticalManagerContext;
import org.gcube.data.analysis.statisticalmanager.db.DataSourceManager;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.operation.OperationStatus;
import org.gcube.data.analysis.statisticalmanager.operation.converter.CSVConverter;
import org.gcube.data.analysis.statisticalmanager.operation.converter.OccurrenceStreamConverter;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataAlreadyExist;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube.data.analysis.statisticalmanager.stubs.StatisticalServicePortType;
import org.gcube.data.analysis.statisticalmanager.types.ComputationType;
import org.gcube.data.analysis.statisticalmanager.types.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerServiceResource;
import org.gcube.data.spd.plugin.fwk.Coordinate;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.binding.Bindings;



import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.queueManager.FactoryConfiguration;
import org.gcube.common.queueManager.QueueType;
import org.gcube.common.queueManager.impl.QueueProducer;
import org.gcube.common.queueManager.impl.QueueProducerFactory;
import org.gcube.common.queueManager.model.QueueItem;
import org.gcube.common.queueManager.model.RequestItem;
import org.gcube.data.streams.Stream;

import org.gcube.data.streams.generators.Generator;


import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;

import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.CSVtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationConfig;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationInfos;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationOutput;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationStatus;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistoryList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ParametersList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataList;
import org.globus.wsrf.ResourceException;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.DestroyResponse;
import org.oasis.wsrf.lifetime.ResourceNotDestroyedFaultType;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.lifetime.TerminationTimeChangeRejectedFaultType;
import org.oasis.wsrf.lifetime.UnableToSetTerminationTimeFaultType;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.InvalidQueryExpressionFaultType;
import org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.properties.InvalidSetResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.properties.QueryEvaluationErrorFaultType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.ResourceUnknownFaultType;
import org.oasis.wsrf.properties.SetResourcePropertiesResponse;
import org.oasis.wsrf.properties.SetResourceProperties_Element;
import org.oasis.wsrf.properties.SetResourcePropertyRequestFailedFaultType;
import org.oasis.wsrf.properties.UnableToModifyResourcePropertyFaultType;
import org.oasis.wsrf.properties.UnknownQueryExpressionDialectFaultType;

public class StatisticalManagerService extends GCUBEPortType implements StatisticalServicePortType {

	
	private GCUBELog logger = new GCUBELog(StatisticalManagerService.class);
	
    
	/** {@inheritDoc} */	
    @Override
	protected ServiceContext getServiceContext() {return ServiceContext.getContext();}

    private StatisticalManagerServiceResource getResource() throws ResourceException {

    	return (StatisticalManagerServiceResource) 
    	StatisticalManagerContext.getContext().getWSHome().find();
    }
    
	@Override
	public String executeComputation(ComputationConfig computationConfig)
			throws RemoteException, GCUBEFault {
		
		logger.debug("Send a new user request");
		try {
			QueueProducerFactory factory = QueueProducerFactory.get(
					new FactoryConfiguration("SomeClass", "SomeName", "vm://localhost", null, null));
			
			QueueProducer<QueueItem> producer = factory.getSubmitter("TEST.FOO3", QueueType.REQUEST);
			
			//TODO computationConfig validation
			
	    	long computationId = getResource().getUserHistoryManager().addComputation(computationConfig);	
			Map<String,Serializable> parameters = new HashMap<String,Serializable>();
			parameters.put("user", getResource().getID().getValue());
			parameters.put("request", computationConfig);
			parameters.put("computationId", computationId);
			
			producer.send(new RequestItem("CallScript", null, parameters));
			return String.valueOf(computationId);
			
		}  catch (Exception e) {
			logger.error("PersistenceException",e);
			throw ServiceContext.getContext().getDefaultException(e).toFault();
		}
	}
    
	@Override
	public ComputationInfos getComputationInfos(String computationId)
			throws RemoteException, GCUBEFault {
		
		OperationStatus status;
		try {
			status =  getResource().getUserHistoryManager().
			getComputationStatus(Long.parseLong(computationId));
		} catch (SMDataPersistenceException e) {
			throw ServiceContext.getContext().getDefaultException(e).toFault();
		}

		switch (status) {
		case PENDING: {

			logger.debug("computation status pending " + computationId);
			ComputationInfos infos = new ComputationInfos(String.valueOf(0),
					null,
					null,
					ComputationStatus.PENDING);
			return infos;
		}	
		case RUNNING: {

			logger.debug("computation status running " + computationId);
			Map<String, ComputationalAgent> agents = getResource().getComputationalAgents();
			
			ComputationInfos infos = null;
			ComputationalAgent agent = agents.get(computationId);	
			if (agent == null) {
				logger.debug("ComputationalAgent not found"); 
//				throw ServiceContext.getContext().
//				getDefaultException(new StatisticalManagerException("Computation status running and " +
//						"ComputationalAgent not found")).toFault();
				infos = new ComputationInfos(String.valueOf(0),
						null,
						null,
						ComputationStatus.PENDING);
			}	else {
				
				infos = new ComputationInfos(
						String.valueOf(agent.getStatus()),
						agent.getResourceLoad(),
						agent.getResources(),
						ComputationStatus.RUNNING);
			}
			return infos; 
		}
		case COMPLETED: {
			
			logger.debug("computation status completed " + computationId);
			ComputationInfos infos = new ComputationInfos(String.valueOf(100),
					null,
					null,
					ComputationStatus.COMPLETED);

			return infos;
		}	
		case FAILED: {

			logger.debug(" computation pending");
			ComputationInfos infos = new ComputationInfos(String.valueOf(100),
					null,
					null,
					ComputationStatus.FAILED);

			return infos;
		}
		default:
			throw ServiceContext.getContext().
			getDefaultException(new StatisticalManagerException("Computation not found"));
		}
		
	}
	
	@Override
	public ComputationOutput getComputationOutput(String computationId)
			throws RemoteException, GCUBEFault {
				
		try {
			return getResource().getUserHistoryManager().
			getComputationOutput(Long.parseLong(computationId));
		} catch (Exception e) {
			throw ServiceContext.getContext().getDefaultException("Output not found", e);
		}
	}

	@Override
	public ItemHistoryList getUserHistory(VOID requestUserHistory)
			throws RemoteException, GCUBEFault {
		
		try {
			return getResource().getUserHistoryManager().getUserHistory();
		} catch (SMDataPersistenceException e) {
			throw getServiceContext().getDefaultException(e).toFault();
		}
		
	}
	

	
	@Override
	public GetMultipleResourcePropertiesResponse getMultipleResourceProperties(
			GetMultipleResourceProperties_Element getMultipleResourcePropertiesRequest)
			throws RemoteException, InvalidResourcePropertyQNameFaultType,
			ResourceUnknownFaultType {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GetResourcePropertyResponse getResourceProperty(
			QName getResourcePropertyRequest) throws RemoteException,
			InvalidResourcePropertyQNameFaultType, ResourceUnknownFaultType {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public DestroyResponse destroy(Destroy destroyRequest)
			throws RemoteException,
			org.oasis.wsrf.lifetime.ResourceUnknownFaultType,
			ResourceNotDestroyedFaultType {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public QueryResourcePropertiesResponse queryResourceProperties(
			QueryResourceProperties_Element queryResourcePropertiesRequest)
			throws RemoteException, UnknownQueryExpressionDialectFaultType,
			InvalidResourcePropertyQNameFaultType,
			InvalidQueryExpressionFaultType, QueryEvaluationErrorFaultType,
			ResourceUnknownFaultType {
		return null;
	}

	@Override
	public SetResourcePropertiesResponse setResourceProperties(
			SetResourceProperties_Element setResourcePropertiesRequest)
			throws RemoteException, InvalidResourcePropertyQNameFaultType,
			InvalidSetResourcePropertiesRequestContentFaultType,
			SetResourcePropertyRequestFailedFaultType,
			ResourceUnknownFaultType, UnableToModifyResourcePropertyFaultType {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SetTerminationTimeResponse setTerminationTime(
			SetTerminationTime setTerminationTimeRequest)
			throws RemoteException, UnableToSetTerminationTimeFaultType,
			org.oasis.wsrf.lifetime.ResourceUnknownFaultType,
			TerminationTimeChangeRejectedFaultType {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public VOID removeComputation(String computationId)
			throws RemoteException, GCUBEFault {
		
		OperationStatus status;
		try {
			
			status = getResource().getUserHistoryManager().
			deleteComputation(Long.parseLong(computationId));
			
			if (status == OperationStatus.RUNNING) {
				
				ComputationalAgent agent = getResource().getComputationalAgents().get(computationId);
				agent.shutdown();
				
				getResource().cleanResourcesComputational(INFRASTRUCTURE.LOCAL, Long.parseLong(computationId));
				getResource().cleanResourcesComputational(INFRASTRUCTURE.D4SCIENCE, Long.parseLong(computationId));
			}
		
		} catch (SMDataPersistenceException e) {
			throw ServiceContext.getContext().getDefaultException(e).toFault();
		}
		 
		
		return null;
	}

	@Override
	public VOID stopComputation(String computationId)
			throws RemoteException, GCUBEFault {
		
		
		return null;
	}	
	
	
}
