package org.gcube.data.analysis.statisticalmanager.types;

import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.TablesList;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTypeParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StatisticalServiceType;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StringValues;

public class FactoryComputationParameter {
	
	static GCUBELog logger = new GCUBELog(FactoryComputationParameter.class);

	public static SMParameter createParameter(StatisticalType type) {
		
		logger.debug(" StatisticalType class " + type.getClass());
		
		SMTypeParameter parameterType = new SMTypeParameter();
		if (type instanceof InputTable){

			parameterType.setName(StatisticalServiceType.TABULAR);
			List<TableTemplates> templateNames = ((InputTable) type).getTemplateNames();
			
			int i = 0;
			String[] values = new String[templateNames.size()];
			for (TableTemplates template : templateNames){
				values[i++] = template.toString();
			}

			parameterType.setValue(new StringValues(values));
			return new SMParameter(type.getDefaultValue(),type.getDescription(),
					type.getName(),parameterType);
		}
		
		if (type instanceof TablesList) {
			parameterType.setName(StatisticalServiceType.TABULAR_LIST);
			List<TableTemplates> templateNames = ((TablesList) type).getTemplates();
			int i = 0;
			String[] values = new String[templateNames.size()];
			for (TableTemplates template : templateNames){
				values[i] = template.toString();
				i++;
			}

			parameterType.setValue(new StringValues(values));
			return new SMParameter(type.getDefaultValue(),type.getDescription(),
					type.getName(),parameterType);
		}
		
		if (((type instanceof PrimitiveType) && ((PrimitiveType)type).getType() != PrimitiveTypes.CONSTANT)){
			
			String[] values = {((PrimitiveType) type).getClassName()};
			
			if(((PrimitiveType) type).getType() == PrimitiveTypes.ENUMERATED) {
				parameterType.setName(StatisticalServiceType.ENUM);
				
				logger.debug("ENUMs Found");
				Enum[] enums = (Enum[]) ((PrimitiveType) type).getContent();
				logger.debug("Cast to enum");
				values = new String[enums.length];
				int i = 0;
				for(Enum en : enums) {
					logger.debug("Enum found");
					values[i] = en.name();
					logger.debug("Enum value " + en.name());
					i++;
				}	
			} else if(((PrimitiveType) type).getType() == PrimitiveTypes.FILE) {
				parameterType.setName(StatisticalServiceType.FILE);
			} else {
				parameterType.setName(StatisticalServiceType.PRIMITIVE); 	
			}
						
			parameterType.setValue(new StringValues(values));
			
			return new SMParameter(type.getDefaultValue(),type.getDescription(),
					type.getName(),parameterType);
		}
		
		if (type instanceof PrimitiveTypesList) {
			
			parameterType.setName(StatisticalServiceType.LIST);
			
			String[] values = {((PrimitiveTypesList)type).getType().toString()};
			parameterType.setValue(new StringValues(values));
			
			return new SMParameter(type.getDefaultValue(),type.getDescription(),
					type.getName(),parameterType);
		}
		
		if (type instanceof ColumnTypesList) {
			
			parameterType.setName(StatisticalServiceType.COLUMN_LIST);
			
			String[] values = {((ColumnTypesList)type).getTabelName()};
			parameterType.setValue(new StringValues(values));
		
			return new SMParameter(type.getDefaultValue(), type.getDescription(),
					type.getName(), parameterType);
		}
		
		if (type instanceof ColumnType) {
			
			parameterType.setName(StatisticalServiceType.COLUMN);
			
			String[] values = {((ColumnType)type).getTableName()};
			parameterType.setValue(new StringValues(values));
		
			return new SMParameter(type.getDefaultValue(), type.getDescription(),
					type.getName(), parameterType);
		}
		
		return null;
	}
	
	public static boolean containParameter(SMTypeParameter typeParameter, List<StatisticalType> statisticalParameters) {
		
		if (typeParameter.getName().equals(StatisticalServiceType.TABULAR)) {
			for(StatisticalType type : statisticalParameters) {
				if (type instanceof InputTable) {
					for (String template : typeParameter.getValue().getValues()) {						
						if (((InputTable)type).getTemplateNames().contains(TableTemplates.GENERIC) ||  
								((InputTable)type).getTemplateNames().contains(TableTemplates.valueOf(template)))
								return true;
					}
				}
			}
		}
		return false;
	}
	
}
