package org.gcube.data.analysis.statisticalmanager.wsresources;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;

import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.db.DataSourceManager;
import org.gcube.data.analysis.statisticalmanager.operation.OperationStatus;
import org.gcube.data.analysis.statisticalmanager.operation.converter.CSVConverter;
import org.gcube.data.analysis.statisticalmanager.operation.converter.OccurrenceStreamConverter;
import org.gcube.data.analysis.statisticalmanager.operation.exception.SMFileManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.UserManager;
import org.gcube.data.analysis.statisticalmanager.util.RSWrapper;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.CSVtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.DataStreamtoTabularRequest;

public class DataSpaceImporterResource extends GCUBEWSResource {

	private String user = null;
	
	private volatile String objectId = null;
	private volatile OperationStatus status = OperationStatus.PENDING;
	private volatile Calendar creationDate;
	
	private volatile String description;
	private volatile String objectType;
	private volatile String objectLabel;
	private volatile Calendar startImport;
	

	@Override
	protected void initialise(Object... params) throws Exception {
		// TODO Auto-generated method stub
		this.user = (String)params[0];
	}
	
	public void createTableFromCSV(final CSVtoTabularRequest request) throws SMFileManagerException {
		
		setStatus(OperationStatus.RUNNING);
		
		setDescription(request.getDescription());
		setObjectType(request.getTableType());
		setObjectLabel(request.getTableName());
		setStartImport(Calendar.getInstance());
		
		Thread th = new Thread(){
			
			@Override
			public void run() {
							
				try {
		
					File file = RSWrapper.getStreamFromLocator(new URI(request.getRsLocator()));
					logger.debug("File path :" + file.getAbsolutePath());
					
					CSVConverter converter = new CSVConverter(file.getAbsolutePath(),
							request.isHasHeader(),request.getTableName(), request.getTableType());
					
					String dbTableName = converter.toTabularData();
					
					UserManager userManager = new UserManager(user);
					userManager.getUserdaDataSpaceManager().addTabularData(request.getTableType(),
							request.getTableName(), dbTableName, request.getDescription());			
					objectId = dbTableName;
					setCreationDate(Calendar.getInstance());
					setStatus(OperationStatus.COMPLETED);
				} catch (Exception e) {
					setStatus(OperationStatus.FAILED);
					logger.error("CSV importer error ",e);
				}
		
			}
		};
		
		th.start();
		
	}
	
	public void createTableFromDataStream(final DataStreamtoTabularRequest request) {
		
		logger.debug("start table creation");
		setStatus(OperationStatus.RUNNING);
		Thread th = new Thread() {
		
			public void run() {
				try {
			
					OccurrenceStreamConverter converter = new OccurrenceStreamConverter(DataSourceManager.getDataSource(),
							request.getRsLocator());
					converter.run();

					UserManager userManager = new UserManager(user);
					userManager.getUserdaDataSpaceManager().addTabularData(request.getTableType(),
							request.getTableName(), converter.getTableName(), request.getDescription());
					objectId = converter.getTableName();
					setStatus(OperationStatus.COMPLETED);
				} catch (Exception e) {
					setStatus(OperationStatus.FAILED);
					logger.error("DataStream importer error ",e);
				}
			}
		};
		th.start();
	}

	private void setStatus(OperationStatus status) {
		this.status = status;
	}

	public OperationStatus getStatus() {
		return status;
	}
	
	public String getUser() {
		return user;
	}
	
	public String getObjectId() {
		return objectId;
	}

	private void setObjectType(String objectType) {
		this.objectType = objectType;
	}

	public String getObjectType() {
		return objectType;
	}

	private void setDescription(String description) {
		this.description = description;
	}

	public String getDescription() {
		return description;
	}

	private void setObjectLabel(String objectLabel) {
		this.objectLabel = objectLabel;
	}

	public String getObjectLabel() {
		return objectLabel;
	}

	private void setStartImport(Calendar startImport) {
		this.startImport = startImport;
	}

	public Calendar getStartImport() {
		return startImport;
	}

	private void setCreationDate(Calendar creationDate) {
		this.creationDate = creationDate;
	}

	public Calendar getCreationDate() {
		return creationDate;
	}
}
