/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.operation.converter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.UUID;
import javax.sql.DataSource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.db.DataSourceManager;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;

public class CSVConverter {
    private static GCUBELog logger = new GCUBELog(CSVConverter.class);
    private String filePath;
    private boolean hasHeader;
    private String tableLabel;
    private String tableTemplate;

    public CSVConverter(String filePath, boolean hasHeader, String tableLabel, String tableTemplate) {
        this.filePath = filePath;
        this.hasHeader = hasHeader;
        this.tableLabel = tableLabel;
        this.tableTemplate = tableTemplate;
    }

    public String toTabularData() throws StatisticalManagerException {
        Connection conn = null;
        PreparedStatement createTable = null;
        PreparedStatement copyTable = null;
        String dbTableName = null;
        try {
            try {
                DataSource dataSource = DataSourceManager.getDataSource();
                dbTableName = String.valueOf(this.tableTemplate) + "_ID" + UUID.randomUUID().toString().replace("-", "_");
                dbTableName = dbTableName.toLowerCase();
                conn = dataSource.getConnection();
                conn.setAutoCommit(false);
                String sql = String.format("create table %s (like %s)", dbTableName, this.tableTemplate);
                logger.debug((Object)("SQL create table: " + sql));
                createTable = conn.prepareStatement(sql);
                createTable.executeUpdate();
                String path = "'" + this.filePath + "'";
                sql = String.format("copy %s from %s %s", dbTableName, path, this.hasHeader ? "CSV HEADER" : "CSV");
                logger.debug((Object)("SQL copy table from file: " + sql));
                copyTable = conn.prepareStatement(sql);
                copyTable.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                logger.error((Object)"CSV importer error :", (Throwable)e);
                DataSourceManager.rollback(conn);
                throw new StatisticalManagerException();
            }
        }
        catch (Throwable throwable) {
            DataSourceManager.closeStatement(createTable);
            DataSourceManager.closeStatement(copyTable);
            DataSourceManager.closeConn(conn);
            throw throwable;
        }
        DataSourceManager.closeStatement(createTable);
        DataSourceManager.closeStatement(copyTable);
        DataSourceManager.closeConn(conn);
        return dbTableName;
    }
}

