package org.gcube.data.analysis.statisticalmanager.operation.converter;

import static org.gcube.data.streams.dsl.Streams.convert;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;

import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.UUID;

import javax.sql.DataSource;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.porttypes.StatisticalManagerService;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.binding.Bindings;
import org.gcube.data.streams.Stream;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;

public class OccurrenceStreamConverter {

	public String getTableName() {
		return tableName;
	}

	private DataSource dataSource;
	private String streamLocator;
	private String tableName;
	
	private static GCUBELog logger = new GCUBELog(StatisticalManagerService.class);

	private void createTable() throws Exception {

		Connection conn = dataSource.getConnection();

		Statement stmt = conn.createStatement();
		String dbTableName = TableTemplates.OCCURRENCE_SPECIES.toString() +  "_ID_" + UUID.randomUUID().toString().replace("-", "_");
		dbTableName = dbTableName.toLowerCase();
		
		String sql = "CREATE TABLE " + dbTableName + 
		"(institutionCode VARCHAR,"+
		"collectionCode VARCHAR," +
		"dataSet VARCHAR," +
		"catalogueNumber VARCHAR," +
		"dataProvider VARCHAR," +
		"dataSource VARCHAR," +
		"recordedBy VARCHAR," +
		"eventDate TIMESTAMP," +
		"modified TIMESTAMP," +
		"scientificName VARCHAR," +	
		"kingdom VARCHAR," +
		"family VARCHAR," +
		"locality VARCHAR," +
		"country VARCHAR," +
		"citation VARCHAR," +
		"decimalLatitude double precision," +
		"decimalLongitude double precision," +
		"coordinateUncertaintyInMeters VARCHAR," +
		"maxDepth double precision," +
		"minDepth double precision," +
		"basisOfRecord VARCHAR)";
		try {
			stmt.executeUpdate(sql);
		} finally {
			try { if(stmt!= null) stmt.close();} catch(Exception e) {}
			try { if(conn!= null) conn.close();} catch(Exception e) {}
		}

		this.tableName = dbTableName;
	}

	public OccurrenceStreamConverter(DataSource dataSource, String streamLocator) throws Exception {

		this.streamLocator = streamLocator;
		this.dataSource = dataSource;
		createTable();
	}

	public void run() throws Exception {
		
		Connection conn = null;
		PreparedStatement pstmt = null;
		try {
			
			conn = dataSource.getConnection();

			String sql = "insert into " + this.tableName + 
			"(institutionCode, "+
			"collectionCode, " +
			"dataSet, " +
			"catalogueNumber, " +
			"dataProvider, " +
			"dataSource, " +
			"recordedBy, " +
			"eventDate, " +
			"modified, " +
			"scientificName, " +	
			"kingdom, " +
			"family, " +
			"locality, " +
			"country, " +
			"citation, " +
			"decimalLatitude, " +
			"decimalLongitude, " +
			"coordinateUncertaintyInMeters, " +
			"maxDepth, " +
			"minDepth, " +
			"basisOfRecord) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			
			pstmt = conn.prepareStatement(sql);
			
			logger.debug("----- Try convert stream ");
			Stream<GenericRecord> stream = convert(URI.create(streamLocator)).of(GenericRecord.class).withDefaults();
			logger.debug("----- Stream converted");
			while(stream.hasNext()) {

				logger.debug("----- Stream has element");
				OccurrencePoint occurrence = Bindings.fromXml(((StringField)stream.next().
						getField("result")).getPayload());

				logger.debug("Occurrence " + occurrence);
				
				pstmt.setString(1, occurrence.getInstitutionCode());
				pstmt.setString(2, occurrence.getCollectionCode());
				
				if (occurrence.getDataSet() != null) {
					pstmt.setString(3, occurrence.getDataSet().getName());
					if (occurrence.getDataSet().getDataProvider() != null)
						pstmt.setString(5, occurrence.getDataSet().getDataProvider().getName());
					else
						pstmt.setString(5, null);
				} else {
					pstmt.setString(3,null);
					pstmt.setString(5, null);
				}
					
				pstmt.setString(4, occurrence.getCatalogueNumber());
				
				pstmt.setString(6, occurrence.getProvider());
				pstmt.setString(7, occurrence.getRecordedBy());
				
				if (occurrence.getEventDate() != null)
					pstmt.setDate(8, new java.sql.Date(occurrence.getEventDate().getTime().getTime()));
				else
					pstmt.setDate(8, null);
				if (occurrence.getModified() != null) 
					pstmt.setDate(9, new java.sql.Date(occurrence.getModified().getTime().getTime()));
				else
					pstmt.setDate(9, null);
				
				pstmt.setString(10, occurrence.getScientificName());
				pstmt.setString(11, occurrence.getKingdom());
				pstmt.setString(12, occurrence.getFamily());
				pstmt.setString(13, occurrence.getLocality());
				pstmt.setString(14, occurrence.getCountry());
				pstmt.setString(15, occurrence.getCitation());
				pstmt.setDouble(16, occurrence.getDecimalLatitude());
				pstmt.setDouble(17, occurrence.getDecimalLongitude());
				pstmt.setString(18, occurrence.getCoordinateUncertaintyInMeters());
				pstmt.setDouble(19, occurrence.getMaxDepth());
				pstmt.setDouble(20, occurrence.getMinDepth());
				
				if (occurrence.getBasisOfRecord() != null)
					pstmt.setString(21, occurrence.getBasisOfRecord().toString());
				else 
					pstmt.setString(21, null);
				
				pstmt.executeUpdate();
			}
			
		}  finally {
			
			try { if(pstmt!= null) pstmt.close();} catch(Exception e) {}
			try { if(conn!= null) conn.close();} catch(Exception e) {}
		}

	}	
}
