package org.gcube.data.analysis.statisticalmanager.persistence;

import static org.gcube.data.analysis.statisticalmanager.persistence.PersistentHibernateManager.closeSession;

import java.util.Date;

import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.data.Computation;
import org.gcube.data.analysis.statisticalmanager.persistence.data.ComputationalInfrastructure;
import org.gcube.data.analysis.statisticalmanager.persistence.data.User;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube.data.analysis.statisticalmanager.types.ComputationInfrastructure;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ComputationalInfrastructureManager {
	
	
	public static void initComputationalInfrastructure(String infra) throws StatisticalManagerException {
		
		Session session = PersistentHibernateManager.
		getSessionFactory().openSession();
		try {
			ComputationalInfrastructure ci = (ComputationalInfrastructure)session.get(ComputationalInfrastructure.class, infra);
			if (ci == null) {
				Transaction t = null;
				try {
					t = session.beginTransaction();
					ci = new ComputationalInfrastructure(infra);
					session.save(ci);
					session.getTransaction().commit();
				} catch (Exception e) {
					
					e.printStackTrace();
					if (t != null) 
						t.rollback();
					
					throw new StatisticalManagerException("ComputationalInfrastructure" +
							" doesn't initialize");
				}
			}
			
		} finally {
			session.close();
			
		}
	}
	
	public static boolean incrementResources(INFRASTRUCTURE infra,
			int maxResources) throws SMDataPersistenceException {
		
		Session session = PersistentHibernateManager.
		getSessionFactory().openSession();
		
		Transaction t = null;
		try {
			t = session.beginTransaction();
		
			ComputationalInfrastructure comp = (ComputationalInfrastructure) session.load(ComputationInfrastructure.class,
					infra);
			
//			int resourcesNumber = comp.getResourcesNumber();
//			if (resourcesNumber >= maxResources)
//				return false;
//			
//			resourcesNumber++;
//			comp.setResourcesNumber(resourcesNumber);
//			
			session.saveOrUpdate(comp);
		
			t.commit();
		} catch (Exception e) {
			
				if(t != null) 
					t.rollback();
			throw new SMDataPersistenceException("Increment infra resources failed");
		} finally {
			closeSession(session);
		}
		
		return true;
	}
	

}
