package org.gcube.data.analysis.statisticalmanager.persistence;


import org.gcube.common.core.utils.logging.GCUBELog;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;


public class PersistentHibernateManager {
	
	private static GCUBELog logger = new GCUBELog(PersistentHibernateManager.class);
	
	private static SessionFactory sessionFactory = buildSessionFactory();

	private static SessionFactory buildSessionFactory() {
		try {
			
			return new Configuration().configure(
					PersistentHibernateManager.class.getResource("hibernate.cfg.xml")
			).buildSessionFactory();

		}
		catch (Throwable ex) {
			// Make sure you log the exception, as it might be swallowed
			logger.error("Initial SessionFactory creation failed." + ex);
			throw new ExceptionInInitializerError(ex);
		}
	}

	public static SessionFactory getSessionFactory() {
		return sessionFactory;
	}
	
	public static void closeSession(Session session) {
		try {if(session!=null)session.close();} catch(Exception e){};
	}
	
	public static void roolbackTransaction(Transaction t){
		try {if(t!=null)t.rollback();} catch(Exception e){};
	}
}
