package org.gcube.data.analysis.statisticalmanager.persistence.data;

import java.io.Serializable;

public class TableMetadataId implements Serializable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4383170298350115942L;
	private String owner;
	private String tableName;
	
	public TableMetadataId() {
	
	}
	
	public TableMetadataId(String name, String tableName) {
		setOwner(name);
		setTableName(tableName);
	}
	
	public void setOwner(String user) {
		this.owner = user;
	}
	
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}
	
	public String getOwner() {
		return owner;
	}
	
	public String getTableName() {
		return tableName;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((tableName == null) ? 0 : tableName.hashCode());
		result = prime * result + ((owner == null) ? 0 : owner.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TableMetadataId other = (TableMetadataId) obj;
		if (tableName == null) {
			if (other.tableName != null)
				return false;
		} else if (!tableName.equals(other.tableName))
			return false;
		if (owner == null) {
			if (other.owner != null)
				return false;
		} else if (!owner.equals(other.owner))
			return false;
		return true;
	}
	
}
