package org.gcube.data.analysis.statisticalmanager.porttypes;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.TimeUnit;



import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;

import org.gcube.common.core.contexts.GCUBEServiceContext.Status;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;

import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.porttypes.GCUBEPortType;

import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.FactoryContext;
import org.gcube.data.analysis.statisticalmanager.context.StatisticalManagerContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.home.StatisticalManagerServiceHome;
import org.gcube.data.analysis.statisticalmanager.types.Couple;
import org.gcube.data.analysis.statisticalmanager.types.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.types.ServiceTopic;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerFactoryResource;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerServiceResource;
import org.gcube.data.analysis.statisticalmanager.persistence.UserHistoryManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserManager;
import org.gcube.data.analysis.statisticalmanager.stubs.FactoryPortType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.queueManager.FactoryConfiguration;
import org.gcube.common.queueManager.QueueItemHandler;
import org.gcube.common.queueManager.QueueType;
import org.gcube.common.queueManager.impl.QueueConsumerFactory;
import org.gcube.common.queueManager.model.RequestItem;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Algorithm;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Feature;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Features;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistoryList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ParametersList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMHistoryRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMHistoryRequestByInputParameters;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTypeParameter;

import edu.emory.mathcs.backport.java.util.Arrays;


public class StatisticalManagerFactory extends GCUBEPortType implements FactoryPortType{    

	GCUBELog logger = new GCUBELog(StatisticalManagerFactory.class);
		
	private static final String keyFRString = "keyFactoryResource";
	private static StatisticalManagerFactoryResource resource;
	
	/** {@inheritDoc} */
	@Override
	protected ServiceContext getServiceContext()  {return ServiceContext.getContext();}

	public static StatisticalManagerFactoryResource getFactoryResource() {
		return resource;
	}
	
	@Override
	public EndpointReferenceType serviceConnect(String token)
			throws RemoteException, GCUBEUnrecoverableFault { 	
		try {
	
			// Instantiate a wsResource to client request
			GCUBEStatefulPortTypeContext stfctx = StatisticalManagerContext.getContext();  
			GCUBEWSResourceKey key = stfctx.makeKey(token);               

			StatisticalManagerServiceHome home = (StatisticalManagerServiceHome)stfctx.getWSHome();
			StatisticalManagerServiceResource wsResource = (StatisticalManagerServiceResource)home.create(key,token);
			
			return wsResource.getEPR();
			
		} catch (Exception e) {
			throw new GCUBEUnrecoverableException(e).toFault();
		}
	}

	@Override
	protected void onInitialisation() throws Exception {

		if (resource != null)
			return;//cannot create the state twice
				
		logger.info("Initialising the factory state...");
		new Thread() {

			@Override
			public void run() {
				int attempts = 0;
				boolean created = false;
				while (attempts++ < 10) {
					try {
						Thread.sleep(1000);
					} catch (InterruptedException e1) {
						logger.error("Failed to sleep in between factory creation");
						ServiceContext.getContext().setStatus(Status.FAILED);
						break;
					}
					try {
						for (GCUBEScope scope: ServiceContext.getContext().getInstance().getScopes().values()){
							
							logger.info("Creating the resource within the scope " + scope.getName());
							ServiceContext.getContext().setScope(scope);
						}
						
						resource = (StatisticalManagerFactoryResource) FactoryContext.getContext().getWSHome().create(FactoryContext.getContext().makeKey(keyFRString));
						
						created = true;
						break;
					} catch (Exception e) {
						logger.error("Failed to create the resource", e);
					}
				}
				if (!created)
					ServiceContext.getContext().setStatus(Status.FAILED);
			}

		}.start();
		
		
	}

	@Override
	public Features getFeatures(VOID arg0) throws RemoteException,
			GCUBEUnrecoverableFault {
		
		logger.debug("GET all features called");
		String configPath = ServiceContext.getContext().getProperty("configDir") + "/cfg/";
		Feature[] features = null;
		try {
			logger.debug("features map ....");
			HashMap<String,List<String>> mapFeatures = ProcessorsFactory.getAllFeatures(configPath);
			
			logger.debug("features map found");			
			features = new Feature[mapFeatures.size()];
			int i = 0;		
			for(Entry<String,List<String>> entry: mapFeatures.entrySet()) {
				
				logger.debug("CATEGORY found " + entry.getKey());
				
				ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
				for (String algorithmName : entry.getValue()) {
					String description = getFactoryResource().getAgorithmDescription(
							entry.getKey(), algorithmName);
					algorithms.add(new Algorithm(description, algorithmName));
					
				}
			
				features[i++] = new Feature( algorithms.toArray(new Algorithm[algorithms.size()]),
						ComputationalAgentClass.fromString(entry.getKey()));
				
			}
			
		} catch (Exception e) {
			throw new GCUBEUnrecoverableException(e).toFault();
		}
		
		return new Features(features);
	}

	@Override
	public ParametersList getAlgorithmParameters(SMComputation computation)
			throws RemoteException, GCUBEFault {
		
		String algorithmDescription = null;
    	List<StatisticalType> parameters = null;  
    	try {
    		parameters = getFactoryResource().getListParameters(
    				computation.getCategory().getValue(), computation.getAlgorithm());
    		algorithmDescription = getFactoryResource().getAgorithmDescription(
    				computation.getCategory().getValue(), computation.getAlgorithm());
    	} catch (Exception e) { 
    		throw ServiceContext.getContext().
    		getDefaultException("Parameters unknown for this computation", e).toFault();
    	}
    	
    	logger.debug("------------- parameters retrieved");
    	ArrayList<SMParameter> listParameters = new ArrayList<SMParameter>();
    	for(StatisticalType param : parameters) {
    		SMParameter smParameter = FactoryComputationParameter.createParameter(param);
    		if(smParameter!=null)listParameters.add(smParameter);	
    	}
    	
    	
		return new ParametersList(algorithmDescription,listParameters.
				toArray(new SMParameter[listParameters.size()]));
	}

	@Override
	public Features getFeaturesForInputParameters(
			SMTypeParameter typeParameter)
			throws RemoteException, GCUBEFault {
		
		String configPath = getFactoryResource().getConfigPath();
		ArrayList<Feature> features = new ArrayList<Feature>();
		try {
			HashMap<String,List<String>> mapFeatures = ProcessorsFactory.getAllFeatures(configPath);
				
			for (Entry<String,List<String>> entry : mapFeatures.entrySet()) {
				String category = entry.getKey();
				Feature feature = new Feature();
				feature.setCategory(ComputationalAgentClass.fromString(category));
				ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
				for (String algorithmName : entry.getValue()){
					List<StatisticalType> parameters = getFactoryResource().getListParameters(category, algorithmName);
					if (FactoryComputationParameter.containParameter(typeParameter, parameters)){
						String description = getFactoryResource().getAgorithmDescription(category, algorithmName);
						algorithms.add(new Algorithm(description, algorithmName));
					}
				}
				
				if (!algorithms.isEmpty()) {
					feature.setAlgorithms(algorithms.toArray(new Algorithm[algorithms.size()]));
					features.add(feature);
				}
			}
		} catch (Exception e) {
			logger.error("Get feature for input parameters ",e);
		}
		
		if (!features.isEmpty()) {
			return new Features(features.toArray(new Feature[features.size()]));
		}
		
		
		return new Features(new Feature[0]);
	}

	@Override
	public ItemHistoryList getUserHistory(SMHistoryRequest request)
			throws RemoteException, GCUBEFault {
		
		try {
			UserHistoryManager historyManager = new UserManager(request.getUser())
			.getUserHistoryManager();
			
			return historyManager.getUserHistory(request);
			
		} catch (StatisticalManagerException e) {
			throw getServiceContext().getDefaultException(e).toFault();
		}
		
	}

	@Override
	public ItemHistoryList getUserHistoryByTypeParameters(
			SMHistoryRequestByInputParameters request)
			throws RemoteException, GCUBEFault {
		
		try {
			
			UserHistoryManager historyManager = new UserManager(request.getUser())
			.getUserHistoryManager();
			
			ArrayList<Feature> features = new ArrayList<Feature>();
			HashMap<String,List<String>> mapFeatures = ProcessorsFactory.
			getAllFeatures(getFactoryResource().getConfigPath());
				
			for (Entry<String,List<String>> entry : mapFeatures.entrySet()) {
				String category = entry.getKey();
				Feature feature = new Feature();
				feature.setCategory(ComputationalAgentClass.fromString(category));
				ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
				for (SMTypeParameter typeParameter : request.getParameter()) {
					for (String algorithm : entry.getValue()){
						List<StatisticalType> parameters = getFactoryResource().getListParameters(category, algorithm);
						if (FactoryComputationParameter.containParameter(typeParameter, parameters)){
							algorithms.add(new Algorithm(null, algorithm));
						}
					}
				}
				
				if (!algorithms.isEmpty()) {
					feature.setAlgorithms(algorithms.toArray(new Algorithm[algorithms.size()]));
					features.add(feature);
				}
			}
			
			ArrayList<ItemHistory> result = new ArrayList<ItemHistory>();
			for (Feature feature : features) {
				for (Algorithm algorithm : feature.getAlgorithms()) {
					ItemHistoryList list = historyManager.getUserHistory(new SMHistoryRequest(algorithm.getName(),
							feature.getCategory().toString(),request.getUser()));
					result.addAll(Arrays.asList(list.getList()));
				}
			}
			
			return new ItemHistoryList(result.
					toArray(new ItemHistory[result.size()]));
		} catch (Exception e) {
			throw getServiceContext().getDefaultException(e).toFault();
		}
		
	}	
	
}
