/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.operation.converter;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.net.URI;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Statement;
import java.util.UUID;
import javax.sql.DataSource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.porttypes.StatisticalManagerService;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.binding.Bindings;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;

public class OccurrenceStreamConverter {
    private DataSource dataSource;
    private String streamLocator;
    private String tableName;
    private static GCUBELog logger = new GCUBELog(StatisticalManagerService.class);

    public String getTableName() {
        return this.tableName;
    }

    private void createTable() throws Exception {
        Connection conn = this.dataSource.getConnection();
        Statement stmt = conn.createStatement();
        String dbTableName = String.valueOf(TableTemplates.OCCURRENCE_SPECIES.toString()) + "_ID_" + UUID.randomUUID().toString().replace("-", "_");
        dbTableName = dbTableName.toLowerCase();
        String sql = "CREATE TABLE " + dbTableName + "(institutionCode VARCHAR," + "collectionCode VARCHAR," + "dataSet VARCHAR," + "catalogueNumber VARCHAR," + "dataProvider VARCHAR," + "dataSource VARCHAR," + "recordedBy VARCHAR," + "eventDate TIMESTAMP," + "modified TIMESTAMP," + "scientificName VARCHAR," + "kingdom VARCHAR," + "family VARCHAR," + "locality VARCHAR," + "country VARCHAR," + "citation VARCHAR," + "decimalLatitude double precision," + "decimalLongitude double precision," + "coordinateUncertaintyInMeters VARCHAR," + "maxDepth double precision," + "minDepth double precision," + "basisOfRecord VARCHAR)";
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
        this.tableName = dbTableName;
    }

    public OccurrenceStreamConverter(DataSource dataSource, String streamLocator) throws Exception {
        this.streamLocator = streamLocator;
        this.dataSource = dataSource;
        this.createTable();
    }

    public void run() throws Exception {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.dataSource.getConnection();
            String sql = "insert into " + this.tableName + "(institutionCode, " + "collectionCode, " + "dataSet, " + "catalogueNumber, " + "dataProvider, " + "dataSource, " + "recordedBy, " + "eventDate, " + "modified, " + "scientificName, " + "kingdom, " + "family, " + "locality, " + "country, " + "citation, " + "decimalLatitude, " + "decimalLongitude, " + "coordinateUncertaintyInMeters, " + "maxDepth, " + "minDepth, " + "basisOfRecord) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            pstmt = conn.prepareStatement(sql);
            logger.debug((Object)"----- Try convert stream ");
            Stream stream = Streams.convert((URI)URI.create(this.streamLocator)).of(GenericRecord.class).withDefaults();
            logger.debug((Object)"----- Stream converted");
            while (stream.hasNext()) {
                logger.debug((Object)"----- Stream has element");
                OccurrencePoint occurrence = (OccurrencePoint)Bindings.fromXml((String)((StringField)((GenericRecord)stream.next()).getField("result")).getPayload());
                logger.debug((Object)("Occurrence " + occurrence));
                pstmt.setString(1, occurrence.getInstitutionCode());
                pstmt.setString(2, occurrence.getCollectionCode());
                if (occurrence.getDataSet() != null) {
                    pstmt.setString(3, occurrence.getDataSet().getName());
                    if (occurrence.getDataSet().getDataProvider() != null) {
                        pstmt.setString(5, occurrence.getDataSet().getDataProvider().getName());
                    } else {
                        pstmt.setString(5, null);
                    }
                } else {
                    pstmt.setString(3, null);
                    pstmt.setString(5, null);
                }
                pstmt.setString(4, occurrence.getCatalogueNumber());
                pstmt.setString(6, occurrence.getProvider());
                pstmt.setString(7, occurrence.getRecordedBy());
                if (occurrence.getEventDate() != null) {
                    pstmt.setDate(8, new Date(occurrence.getEventDate().getTime().getTime()));
                } else {
                    pstmt.setDate(8, null);
                }
                if (occurrence.getModified() != null) {
                    pstmt.setDate(9, new Date(occurrence.getModified().getTime().getTime()));
                } else {
                    pstmt.setDate(9, null);
                }
                pstmt.setString(10, occurrence.getScientificName());
                pstmt.setString(11, occurrence.getKingdom());
                pstmt.setString(12, occurrence.getFamily());
                pstmt.setString(13, occurrence.getLocality());
                pstmt.setString(14, occurrence.getCountry());
                pstmt.setString(15, occurrence.getCitation());
                pstmt.setDouble(16, occurrence.getDecimalLatitude());
                pstmt.setDouble(17, occurrence.getDecimalLongitude());
                pstmt.setString(18, occurrence.getCoordinateUncertaintyInMeters());
                pstmt.setDouble(19, occurrence.getMaxDepth());
                pstmt.setDouble(20, occurrence.getMinDepth());
                if (occurrence.getBasisOfRecord() != null) {
                    pstmt.setString(21, occurrence.getBasisOfRecord().toString());
                } else {
                    pstmt.setString(21, null);
                }
                pstmt.executeUpdate();
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

