/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.io.Serializable;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.PersistentHibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.data.ComputationalInfrastructure;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube.data.analysis.statisticalmanager.types.ComputationInfrastructure;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class ComputationalInfrastructureManager {
    public static void initComputationalInfrastructure(String infra) throws StatisticalManagerException {
        block6: {
            Session session = PersistentHibernateManager.getSessionFactory().openSession();
            try {
                ComputationalInfrastructure ci = (ComputationalInfrastructure)session.get(ComputationalInfrastructure.class, (Serializable)((Object)infra));
                if (ci != null) break block6;
                Transaction t = null;
                try {
                    t = session.beginTransaction();
                    ci = new ComputationalInfrastructure(infra);
                    session.save((Object)ci);
                    session.getTransaction().commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (t != null) {
                        t.rollback();
                    }
                    throw new StatisticalManagerException("ComputationalInfrastructure doesn't initialize");
                }
            }
            finally {
                session.close();
            }
        }
    }

    public static boolean incrementResources(INFRASTRUCTURE infra, int maxResources) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                ComputationalInfrastructure comp = (ComputationalInfrastructure)session.load(ComputationInfrastructure.class, (Serializable)infra);
                session.saveOrUpdate((Object)comp);
                t.commit();
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                throw new SMDataPersistenceException("Increment infra resources failed");
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
        return true;
    }
}

