/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.operation.OperationStatus;
import org.gcube.data.analysis.statisticalmanager.operation.exception.SMFileManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.PersistentHibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.data.Computation;
import org.gcube.data.analysis.statisticalmanager.persistence.data.FileOutput;
import org.gcube.data.analysis.statisticalmanager.persistence.data.ObjectOutput;
import org.gcube.data.analysis.statisticalmanager.persistence.data.Output;
import org.gcube.data.analysis.statisticalmanager.persistence.data.TabularOutput;
import org.gcube.data.analysis.statisticalmanager.persistence.data.User;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceNotExists;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationConfig;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationOutput;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationStatus;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistoryList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMHistoryRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTypeParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StatisticalServiceType;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StringValues;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class UserHistoryManager {
    GCUBELog logger = new GCUBELog(UserHistoryManager.class);
    private String userLogin;

    public UserHistoryManager(String userLogin) {
        this.userLogin = userLogin;
    }

    public long addComputation(ComputationConfig config) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        Transaction t = null;
        long computationId = 0L;
        try {
            try {
                t = session.beginTransaction();
                this.logger.debug((Object)"create Computation");
                Computation comp = new Computation(config.getComputation().getCategory().getValue(), config.getComputation().getAlgorithm(), config.getComputation().getDescription(), new Date());
                session.save((Object)comp);
                User user = (User)session.load(User.class, (Serializable)((Object)this.userLogin));
                user.getComputations().add(comp);
                session.update((Object)user);
                t.commit();
                computationId = comp.getComputationId();
            }
            catch (Exception e) {
                this.logger.error((Object)"Error in create computation ", (Throwable)e);
                if (t != null) {
                    t.rollback();
                }
                throw new SMDataPersistenceException("Computation is not saved");
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
        return computationId;
    }

    public ComputationOutput getComputationOutput(long computationId) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        try {
            ComputationOutput computationOutuput;
            Computation computation = (Computation)session.load(Computation.class, (Serializable)Long.valueOf(computationId));
            Output output = computation.getOutput();
            ComputationOutput computationOutput = computationOutuput = this.convertOutputToComputationOutput(output);
            return computationOutput;
        }
        catch (Exception e) {
            throw new SMDataPersistenceException("Computation output not found");
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public void setStatusComputation(long computationId, OperationStatus status) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                Computation comp = (Computation)session.load(Computation.class, (Serializable)Long.valueOf(computationId));
                comp.setStatus(status);
                comp.setEndDate(new Date());
                session.saveOrUpdate((Object)comp);
                t.commit();
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                throw new SMDataPersistenceException("Statut is not set");
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public void setComputationalInfrastructure(long computationId, INFRASTRUCTURE infrastructure) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                Computation comp = (Computation)session.load(Computation.class, (Serializable)Long.valueOf(computationId));
                comp.setInfrastructure(infrastructure);
                session.saveOrUpdate((Object)comp);
                t.commit();
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                throw new SMDataPersistenceException("Set conputational infrastructure failed");
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public void setComputationObjectOutput(long computationId, String fileName, PrimitiveTypes objectType) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                Computation comp = (Computation)session.load(Computation.class, (Serializable)Long.valueOf(computationId));
                ObjectOutput output = new ObjectOutput(fileName, objectType);
                comp.setOutput(output);
                output.setComputation(comp);
                session.save((Object)output);
                session.update((Object)comp);
                t.commit();
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                this.logger.error((Object)"Output not set", (Throwable)e);
                throw new SMDataPersistenceException("Outuput is not set ");
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public void setComputationFileOutput(long computationId, String value) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                Computation comp = (Computation)session.load(Computation.class, (Serializable)Long.valueOf(computationId));
                FileOutput output = new FileOutput(value);
                comp.setOutput(output);
                output.setComputation(comp);
                session.save((Object)output);
                session.update((Object)comp);
                t.commit();
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                throw new SMDataPersistenceException("Outuput is not set ");
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public void setComputationTabularOutput(long computationId, String value) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                Computation comp = (Computation)session.load(Computation.class, (Serializable)Long.valueOf(computationId));
                TabularOutput output = new TabularOutput(value);
                comp.setOutput(output);
                output.setComputation(comp);
                session.save((Object)output);
                session.update((Object)comp);
                t.commit();
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                throw new SMDataPersistenceException("Outuput is not set ");
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public ComputationOutput convertOutputToComputationOutput(Output output) throws SMFileManagerException {
        ComputationOutput out = new ComputationOutput();
        SMTypeParameter type = new SMTypeParameter();
        switch (output.getType()) {
            case TABULAR: {
                TabularOutput tabularOutput = (TabularOutput)output;
                out.setValue(tabularOutput.getTableName());
                type.setName(StatisticalServiceType.fromString((String)output.getType().toString()));
                String[] tamplates = new String[]{tabularOutput.getTableTemplate()};
                type.setValue(new StringValues(tamplates));
                break;
            }
            case FILE: {
                out.setValue(((FileOutput)output).getUrl());
                type.setName(StatisticalServiceType.fromString((String)output.getType().toString()));
                break;
            }
            case OBJECT: {
                ObjectOutput objectOutput = (ObjectOutput)output;
                out.setValue(objectOutput.getObjectFileName());
                type.setName(StatisticalServiceType.PRIMITIVE);
                String[] primitiveType = new String[]{objectOutput.getObjectType().toString()};
                type.setValue(new StringValues(primitiveType));
                break;
            }
        }
        out.setType(type);
        return out;
    }

    private ItemHistory[] buildItemHistory(List<? extends Object> objects) throws SMFileManagerException {
        ItemHistory[] items = new ItemHistory[objects.size()];
        int i = 0;
        for (Object object : objects) {
            Output output;
            Computation computation = (Computation)object;
            SMComputation smComp = new SMComputation(computation.getAlgorithm(), ComputationalAgentClass.fromString((String)computation.getCategory()), computation.getDescription());
            items[i] = new ItemHistory();
            items[i].setComputationId(computation.getComputationId());
            Calendar startDate = Calendar.getInstance();
            startDate.setTime(computation.getStartDate());
            items[i].setStartDate(startDate);
            if (computation.getEndDate() != null) {
                Calendar endDate = Calendar.getInstance();
                endDate.setTime(computation.getEndDate());
                items[i].setEndDate(endDate);
            }
            items[i].setComputation(smComp);
            items[i].setComputationStatus(ComputationStatus.fromString((String)computation.getStatus().toString()));
            if (computation.getInfrastructure() != null) {
                items[i].setInfrastructure(computation.getInfrastructure().toString());
            }
            if ((output = computation.getOutput()) != null) {
                ComputationOutput compOut = this.convertOutputToComputationOutput(output);
                items[i].setOutput(compOut);
            }
            ++i;
        }
        return items;
    }

    public ItemHistoryList getUserHistory() throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        ItemHistory[] items = null;
        try {
            try {
                Query query = session.createQuery("select c from User u join u.computations usercomputation, Computation c where u.username = :name and c.computationId = usercomputation.computationId ");
                query.setParameter("name", (Object)this.userLogin);
                List objects = query.list();
                items = this.buildItemHistory(objects);
            }
            catch (Exception e) {
                this.logger.error((Object)("-------- Exception " + e));
                throw new SMDataPersistenceException("User computations list not found " + e.getMessage());
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
        return new ItemHistoryList(items);
    }

    public OperationStatus getComputationStatus(long computationId) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        try {
            Computation computation = (Computation)session.get(Computation.class, (Serializable)Long.valueOf(computationId));
            if (computation == null) {
                throw new SMDataPersistenceNotExists("computation with id" + computationId);
            }
            OperationStatus operationStatus = computation.getStatus();
            return operationStatus;
        }
        catch (Exception e) {
            throw new SMDataPersistenceException(e.getMessage());
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public OperationStatus deleteComputation(long computationId) throws SMDataPersistenceException {
        OperationStatus status;
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                User user = (User)session.load(User.class, (Serializable)((Object)this.userLogin));
                Output output = (Output)session.get(Output.class, (Serializable)Long.valueOf(computationId));
                if (output != null) {
                    session.delete((Object)output);
                }
                Computation computation = (Computation)session.get(Computation.class, (Serializable)Long.valueOf(computationId));
                status = computation.getStatus();
                user.getComputations().remove(computation);
                session.delete((Object)computation);
                t.commit();
            }
            catch (Exception e) {
                throw new SMDataPersistenceException(e.getMessage());
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
        return status;
    }

    public ItemHistoryList getUserHistory(SMHistoryRequest request) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        ItemHistory[] items = null;
        try {
            try {
                String hql = "select c from User u right join u.computations usercomputation, Computation c where u.username = :name and c.computationId = usercomputation.computationId";
                if (request.getCategory() != null) {
                    hql = String.valueOf(hql) + " and c.category = :category";
                }
                if (request.getAlgorithm() != null) {
                    hql = String.valueOf(hql) + " and c.algorithm = :algorithm";
                }
                Query query = session.createQuery(hql);
                query.setParameter("name", (Object)this.userLogin);
                if (request.getCategory() != null) {
                    query.setParameter("category", (Object)request.getCategory());
                }
                if (request.getAlgorithm() != null) {
                    query.setParameter("algorithm", (Object)request.getAlgorithm());
                }
                List objects = query.list();
                items = this.buildItemHistory(objects);
            }
            catch (Exception e) {
                this.logger.error((Object)("-------- Exception " + e));
                throw new SMDataPersistenceException("User computations list not found " + e.getMessage());
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
        return new ItemHistoryList(items);
    }
}

