/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.wsresources;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.db.DataSourceManager;
import org.gcube.data.analysis.statisticalmanager.operation.OperationStatus;
import org.gcube.data.analysis.statisticalmanager.operation.importer.FileManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserDataSpaceManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserHistoryManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserManager;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube.data.analysis.statisticalmanager.porttypes.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.porttypes.exception.SMComputationalAgentInitializationException;
import org.gcube.data.analysis.statisticalmanager.porttypes.exception.SMParametersSettingException;
import org.gcube.data.analysis.statisticalmanager.porttypes.exception.SMResourcesNotAvailableException;
import org.gcube.data.analysis.statisticalmanager.types.ComputationType;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationConfig;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.encoding.SerializationException;
import org.w3c.dom.Element;

public class StatisticalManagerServiceResource
extends GCUBEWSResource {
    private static final String NAME_RP_NAME = "computation";
    private UserManager userManager;
    private UserHistoryManager userHistoryManager;
    private UserDataSpaceManager userDataSpaceManager;
    private static FileManager fileManager = new FileManager(ServiceContext.getContext().getPersistenceRoot().getAbsolutePath());
    private static ConcurrentHashMap<String, ComputationalAgent> runningCAgents = new ConcurrentHashMap();

    private String getConfigPath() {
        return ServiceContext.getContext().getProperty("configDir", new boolean[0]) + "/cfg/";
    }

    public void cleanResourcesComputational(INFRASTRUCTURE compInf, long computationId) {
        switch (compInf) {
            case LOCAL: {
                this.logger.debug((Object)"---------- Clean up local resources");
                StatisticalManagerFactory.getFactoryResource().cleanLocalResourcesComputational(String.valueOf(computationId));
                break;
            }
            case D4SCIENCE: {
                this.logger.debug((Object)"--------- Clen up D4Science resources");
            }
        }
    }

    private synchronized void addComputationalAgent(String key, ComputationalAgent agent) {
        runningCAgents.put(key, agent);
        ResourceProperty property = this.getResourcePropertySet().get(NAME_RP_NAME);
        property.add((Object)key);
    }

    private synchronized void removeComputationalAgent(String key) {
        runningCAgents.remove(key);
        ResourceProperty property = this.getResourcePropertySet().get(NAME_RP_NAME);
        try {
            Element[] elementArray = property.toElements();
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element e = elementArray[n2];
                System.out.println("Element property " + e);
                ++n2;
            }
        }
        catch (SerializationException e) {
            this.logger.error((Object)"Serialization property exception ", (Throwable)e);
        }
        Object o = null;
        Iterator iter = property.iterator();
        while (iter.hasNext()) {
            this.logger.debug((Object)("REMOVE RP VALUE " + o));
            o = iter.next();
        }
    }

    private void notifyDidCompletedComputation(long computationId) {
        ComputationalAgent agent = runningCAgents.get(String.valueOf(computationId));
        try {
            this.setComputationOutput(computationId, agent);
            this.userHistoryManager.setStatusComputation(computationId, OperationStatus.COMPLETED);
        }
        catch (Exception e) {
            this.logger.error((Object)"Computation completed with error ", (Throwable)e);
            try {
                this.userHistoryManager.setStatusComputation(computationId, OperationStatus.FAILED);
            }
            catch (SMDataPersistenceException e1) {
                this.logger.error((Object)"Computation completed with some error", (Throwable)e);
            }
        }
        this.removeComputationalAgent(String.valueOf(computationId));
    }

    private void setComputationOutput(long computationId, ComputationalAgent agent) throws Exception {
        StatisticalType output = agent.getOutput();
        this.logger.debug((Object)("ComputationalAgent getOutput() : " + agent.getOutput().getClass().getName()));
        if (output instanceof PrimitiveType) {
            this.logger.debug((Object)("Service package " + ServiceContext.class.getPackage().getName()));
            this.logger.debug((Object)("User " + this.userManager.getUserId()));
            this.logger.debug((Object)("SCOPE " + ServiceContext.getContext().getInstance().getScopes()));
            IClient client = new StorageClient(ServiceContext.class.getPackage().getName(), "StatisticalManager", this.userManager.getUserId(), AccessType.SHARED, GCUBEScope.getScope((String)"/gcube")).getClient();
            String rootDir = "/rootStatisticalManager/";
            if (((PrimitiveType)output).getType() == PrimitiveTypes.FILE) {
                this.logger.debug((Object)"Output is a file");
                this.logger.debug((Object)("Output file path" + ((File)((PrimitiveType)output).getContent()).getAbsolutePath()));
                File outputFile = (File)((PrimitiveType)output).getContent();
                String rfileName = String.valueOf(rootDir) + outputFile.getName();
                client.put(true).LFile(outputFile.getAbsolutePath()).RFile(rfileName);
                String url = client.getUrl().RFile(rfileName);
                this.logger.debug((Object)("URL :" + url));
                this.userHistoryManager.setComputationFileOutput(computationId, url);
                return;
            }
            if (((PrimitiveType)output).getType() == PrimitiveTypes.MAP) {
                this.logger.debug((Object)" ---------------- Map output --------------");
                Map object = (Map)((PrimitiveType)output).getContent();
                this.logger.debug((Object)("Serialize map object :" + object));
                String filePath = fileManager.serializeObject(object, ".smm");
                this.logger.debug((Object)("Object serialized in file " + filePath));
                File file = new File(filePath);
                String rfileName = String.valueOf(rootDir) + file.getName();
                client.put(true).LFile(filePath).RFile(rfileName);
                this.logger.debug((Object)("File put with name " + rfileName));
                String url = client.getUrl().RFile(rfileName);
                this.logger.debug((Object)("URL :" + url));
                this.userHistoryManager.setComputationObjectOutput(computationId, url, PrimitiveTypes.MAP);
                file.delete();
                return;
            }
            if (((PrimitiveType)output).getType() == PrimitiveTypes.IMAGES) {
                this.logger.debug((Object)" ---------------- IMAGES output --------------");
                Map map = (Map)((PrimitiveType)output).getContent();
                this.logger.debug((Object)" ------------------ Cast to map of images ---------");
                String dirName = "/" + UUID.randomUUID().toString();
                this.logger.debug((Object)(" ------------------- DIR CREATED : " + dirName));
                for (Map.Entry entry : map.entrySet()) {
                    this.logger.debug((Object)("Image " + (String)entry.getKey() + " found"));
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    boolean result = ImageIO.write((RenderedImage)ImageTools.toBufferedImage((Image)((Image)entry.getValue())), "png", os);
                    this.logger.debug((Object)("Image stored " + result));
                    String clientResult = client.put(true).LFile((InputStream)new ByteArrayInputStream(os.toByteArray())).RFile(String.valueOf(dirName) + "/" + (String)entry.getKey());
                    this.logger.debug((Object)("ClientResult" + clientResult));
                }
                this.userHistoryManager.setComputationObjectOutput(computationId, dirName, PrimitiveTypes.IMAGES);
            }
        }
        if (output instanceof OutputTable) {
            this.logger.debug((Object)"Add tabular data");
            this.userDataSpaceManager.addTabularData(((TableTemplates)((OutputTable)output).getTemplateNames().get(0)).toString(), output.getName(), ((OutputTable)output).getTableName(), output.getDescription());
            this.logger.debug((Object)"Add tabular data completed");
            this.userHistoryManager.setComputationTabularOutput(computationId, ((OutputTable)output).getTableName());
            this.logger.debug((Object)"Add computation in user history");
            return;
        }
    }

    public void initialise(Object ... args) throws Exception {
        this.logger.debug((Object)"------ initialize Service Resource");
        String userLogin = (String)args[0];
        this.userManager = new UserManager(userLogin);
        this.userHistoryManager = this.userManager.getUserHistoryManager();
        this.userDataSpaceManager = this.userManager.getUserdaDataSpaceManager();
    }

    protected String[] getPropertyNames() {
        return new String[]{NAME_RP_NAME};
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public UserHistoryManager getUserHistoryManager() {
        return this.userHistoryManager;
    }

    public UserDataSpaceManager getUserDataSpaceManager() {
        return this.userDataSpaceManager;
    }

    public ConcurrentHashMap<String, ComputationalAgent> getComputationalAgents() {
        return runningCAgents;
    }

    private AlgorithmConfiguration setUserParameters(AlgorithmConfiguration algoConfig, ComputationConfig requestConfig) {
        this.logger.debug((Object)("Getting paramters " + requestConfig.getParameters()));
        this.logger.debug((Object)("Getting parameters list" + requestConfig.getParameters().getList()));
        this.logger.debug((Object)("Getting parameters list size" + requestConfig.getParameters().getList().length));
        SMEntry[] sMEntryArray = requestConfig.getParameters().getList();
        int n = sMEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SMEntry parameter = sMEntryArray[n2];
            this.logger.debug((Object)("Set Parameter user key " + parameter.getKey() + " value " + parameter.getValue()));
            String value = parameter.getValue();
            algoConfig.setParam(parameter.getKey(), value);
            ++n2;
        }
        return algoConfig;
    }

    public List<StatisticalType> getListParameters(SMComputation computation) throws Exception {
        switch (ComputationType.valueOf(computation.getCategory().getValue())) {
            case DISTRIBUTIONS: {
                return GeneratorsFactory.getAlgorithmParameters((String)this.getConfigPath(), (String)computation.getAlgorithm());
            }
            case EVALUATORS: {
                return EvaluatorsFactory.getEvaluatorParameters((String)this.getConfigPath(), (String)computation.getAlgorithm());
            }
            case MODELS: {
                return ModelersFactory.getModelParameters((String)this.getConfigPath(), (String)computation.getAlgorithm());
            }
            case TRANSDUCERERS: {
                return TransducerersFactory.getTransducerParameters((String)this.getConfigPath(), (String)computation.getAlgorithm());
            }
            case CLUSTERERS: {
                return ClusterersFactory.getClustererParameters((String)this.getConfigPath(), (String)computation.getAlgorithm());
            }
        }
        throw new Exception();
    }

    private void setServiceParameters(ComputationConfig computationConfig, AlgorithmConfiguration algoConfig, List<StatisticalType> parameters) throws SMParametersSettingException {
        this.logger.debug((Object)("Parameter retrieved " + parameters.size()));
        for (StatisticalType parameter : parameters) {
            this.logger.debug((Object)("Parameter retrieved " + parameter.getClass()));
            if (parameter instanceof DatabaseType) {
                switch (((DatabaseType)parameter).getDatabaseParameter()) {
                    case DATABASEURL: {
                        algoConfig.setParam(parameter.getName(), DataSourceManager.getUrlDB());
                        break;
                    }
                    case DATABASEPASSWORD: {
                        algoConfig.setParam(parameter.getName(), DataSourceManager.getPassword());
                        break;
                    }
                    case DATABASEUSERNAME: {
                        algoConfig.setParam(parameter.getName(), DataSourceManager.getUsername());
                        break;
                    }
                    case DATABASEDRIVER: {
                        algoConfig.setParam(parameter.getName(), DataSourceManager.getDriver());
                        break;
                    }
                }
            }
            if (parameter instanceof ServiceType) {
                if (((ServiceType)parameter).getServiceParameter() == ServiceParameters.RANDOMSTRING) {
                    String id = "ID_" + UUID.randomUUID().toString().replace("-", "_");
                    if (parameter.getDefaultValue() != null) {
                        id = String.valueOf(parameter.getDefaultValue()) + id;
                    }
                    this.logger.debug((Object)("Param service name:" + parameter.getName() + " value :" + id.toLowerCase()));
                    algoConfig.setParam(parameter.getName(), id.toLowerCase());
                }
                if (((ServiceType)parameter).getServiceParameter() == ServiceParameters.USERNAME) {
                    this.logger.debug((Object)("Param service name:" + parameter.getName() + " value :" + ((GCUBEWSResourceKey)this.getID()).getValue()));
                    algoConfig.setParam(parameter.getName(), ((GCUBEWSResourceKey)this.getID()).getValue());
                }
                if (((ServiceType)parameter).getServiceParameter() == ServiceParameters.SERVICE) {
                    this.logger.debug((Object)("Param name:" + parameter.getName() + " value : unknow"));
                }
                if (((ServiceType)parameter).getServiceParameter() == ServiceParameters.INFRA) {
                    this.logger.debug((Object)("Param name:" + parameter.getName() + " value : unknow"));
                }
            }
            if (!(parameter instanceof PrimitiveType) || ((PrimitiveType)parameter).getType() != PrimitiveTypes.CONSTANT) continue;
            algoConfig.setParam(parameter.getName(), parameter.getDefaultValue());
            this.logger.debug((Object)("Param primitive name constant : " + parameter.getName() + " value : " + parameter.getDefaultValue()));
        }
    }

    public void executeComputation(ComputationConfig computationConfig, long computationId) throws SMResourcesNotAvailableException {
        AlgorithmConfiguration algoConfig = new AlgorithmConfiguration();
        String algorithm = null;
        try {
            this.logger.debug((Object)" ------------- Computation request: ");
            String configPath = this.getConfigPath();
            algorithm = computationConfig.getComputation().getAlgorithm();
            this.logger.debug((Object)(" ------------- Algorithm request" + algorithm));
            algoConfig.setConfigPath(configPath);
            algoConfig.setAgent(algorithm);
            algoConfig.setModel(algorithm);
            algoConfig.setPersistencePath(configPath);
            this.logger.debug((Object)"Set user parameters init");
            this.setUserParameters(algoConfig, computationConfig);
            this.logger.debug((Object)"Set service paramter init");
            List<StatisticalType> parameters = this.getListParameters(computationConfig.getComputation());
            this.setServiceParameters(computationConfig, algoConfig, parameters);
        }
        catch (Exception e) {
            this.logger.error((Object)"Set service parameter error in execute computation :", (Throwable)e);
            try {
                this.userHistoryManager.setStatusComputation(computationId, OperationStatus.FAILED);
            }
            catch (SMDataPersistenceException e1) {
                this.logger.error((Object)"Set status failed error in excute computation set parameters :", (Throwable)e);
            }
            return;
        }
        try {
            this.logger.debug((Object)"Init computation");
            this.initComputation(computationConfig, algorithm, algoConfig, computationId);
        }
        catch (SMComputationalAgentInitializationException e) {
            this.logger.error((Object)"Init computation failed", (Throwable)e);
            try {
                this.userHistoryManager.setStatusComputation(computationId, OperationStatus.FAILED);
            }
            catch (SMDataPersistenceException e1) {
                this.logger.error((Object)"Set status failed error in init computation :", (Throwable)e);
            }
        }
    }

    private void startComputation(final long computationId, final INFRASTRUCTURE infra, final ComputationalAgent agent) throws SMComputationalAgentInitializationException, SMDataPersistenceException {
        try {
            agent.init();
        }
        catch (Exception e) {
            this.logger.error((Object)"ComputationalAgent initialization failed :", (Throwable)e);
            throw new SMComputationalAgentInitializationException("Agent initialization failed");
        }
        this.addComputationalAgent(String.valueOf(computationId), agent);
        this.userHistoryManager.setStatusComputation(computationId, OperationStatus.RUNNING);
        new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        agent.compute();
                        StatisticalManagerServiceResource.this.notifyDidCompletedComputation(computationId);
                    }
                    catch (Exception e) {
                        StatisticalManagerServiceResource.this.logger.error((Object)"Compute action failed", (Throwable)e);
                        try {
                            StatisticalManagerServiceResource.this.userHistoryManager.setStatusComputation(computationId, OperationStatus.FAILED);
                        }
                        catch (SMDataPersistenceException e1) {
                            StatisticalManagerServiceResource.this.logger.error((Object)("Error save status FAILED computation " + computationId), (Throwable)e);
                        }
                        StatisticalManagerServiceResource.this.cleanResourcesComputational(infra, computationId);
                    }
                }
                finally {
                    StatisticalManagerServiceResource.this.cleanResourcesComputational(infra, computationId);
                }
            }
        }.start();
    }

    private List<? extends ComputationalAgent> getComputationalAgentsAvailable(ComputationConfig computationConfig, AlgorithmConfiguration algoConfig) throws SMComputationalAgentInitializationException {
        ComputationalAgentClass cac = computationConfig.getComputation().getCategory();
        try {
            switch (ComputationType.valueOf(cac.getValue())) {
                case DISTRIBUTIONS: {
                    return GeneratorsFactory.getGenerators((AlgorithmConfiguration)algoConfig);
                }
                case EVALUATORS: {
                    return EvaluatorsFactory.getEvaluators((AlgorithmConfiguration)algoConfig);
                }
                case CLUSTERERS: {
                    return ClusterersFactory.getClusterers((AlgorithmConfiguration)algoConfig);
                }
                case MODELS: {
                    return ModelersFactory.getModelers((AlgorithmConfiguration)algoConfig);
                }
                case TRANSDUCERERS: {
                    return TransducerersFactory.getTransducerers((AlgorithmConfiguration)algoConfig);
                }
            }
            this.logger.error((Object)"Computational agent category not found ");
            throw new Exception();
        }
        catch (Exception e) {
            this.logger.error((Object)"Computational agent list not found", (Throwable)e);
            throw new SMComputationalAgentInitializationException("Algorithm requested not found" + cac.getValue());
        }
    }

    private void initComputation(ComputationConfig computationConfig, String algorithm, AlgorithmConfiguration algoConfig, long computationId) throws SMComputationalAgentInitializationException, SMResourcesNotAvailableException {
        this.logger.debug((Object)" GET ComputationalAgent List ...");
        algoConfig.setNumberOfResources(Integer.valueOf(1));
        List<? extends ComputationalAgent> agents = this.getComputationalAgentsAvailable(computationConfig, algoConfig);
        this.logger.debug((Object)(" FOUND Generetors List with size ..." + agents));
        for (ComputationalAgent computationalAgent : agents) {
            this.logger.debug((Object)("INFRASTRACTURE for ComputationalAgent found : " + computationalAgent.getInfrastructure().toString()));
            switch (computationalAgent.getInfrastructure()) {
                case D4SCIENCE: {
                    this.logger.debug((Object)"Start D4Science computation");
                    try {
                        algoConfig.setGcubeScope("/gcube");
                        this.logger.debug((Object)"Retrieve ComputationalAgent parameters .... ");
                        List parameters = computationalAgent.getInputParameters();
                        this.setServiceParameters(computationConfig, algoConfig, parameters);
                        computationalAgent.setConfiguration(algoConfig);
                        this.getUserHistoryManager().setComputationalInfrastructure(computationId, INFRASTRUCTURE.D4SCIENCE);
                        this.startComputation(computationId, INFRASTRUCTURE.D4SCIENCE, computationalAgent);
                        this.logger.debug((Object)"Computation started in D4Science ... ");
                        return;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Start computation failed", (Throwable)e);
                        this.cleanResourcesComputational(INFRASTRUCTURE.LOCAL, computationId);
                        throw new SMComputationalAgentInitializationException("ComputationalAgent initialization failed " + e.getMessage());
                    }
                }
                case LOCAL: {
                    int resources = StatisticalManagerFactory.getFactoryResource().setLocalResourcesAvailable(String.valueOf(computationId), computationConfig.getComputation());
                    if (resources <= 0) {
                        throw new SMResourcesNotAvailableException("Local Resources not available");
                    }
                    try {
                        this.logger.debug((Object)"Set number of resources ");
                        algoConfig.setNumberOfResources(Integer.valueOf(resources));
                        computationalAgent.setConfiguration(algoConfig);
                        this.startComputation(computationId, INFRASTRUCTURE.LOCAL, computationalAgent);
                        this.logger.debug((Object)"Computation started in LOCAL ...");
                        this.getUserHistoryManager().setComputationalInfrastructure(computationId, INFRASTRUCTURE.LOCAL);
                        return;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Start computation failed", (Throwable)e);
                        this.cleanResourcesComputational(INFRASTRUCTURE.LOCAL, computationId);
                        throw new SMComputationalAgentInitializationException("ComputationalAgent initialization failed " + e.getMessage());
                    }
                }
            }
        }
        throw new SMComputationalAgentInitializationException("Computation initialization failed");
    }
}

