package org.gcube.data.analysis.statisticalmanager.persistence;

import static org.gcube.data.analysis.statisticalmanager.persistence.PersistentHibernateManager.*;

import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.persistence.data.TableMetadata;
import org.gcube.data.analysis.statisticalmanager.persistence.data.TableMetadataId;
import org.gcube.data.analysis.statisticalmanager.persistence.data.User;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadata;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataList;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.exception.ConstraintViolationException;


public class UserDataSpaceManager {

	private GCUBELog logger = new GCUBELog(UserDataSpaceManager.class);
	private String userLogin;
	
	public UserDataSpaceManager(String userLogin) {	
		this.userLogin = userLogin;
	}
	
	public boolean existTabularData(String tableName) {
		
		boolean result = false;
		Session session = getSessionFactory().openSession();
		try {
			TableMetadataId tableId = new TableMetadataId(userLogin, tableName);
			if (session.get(TableMetadata.class, tableId) != null)
				result = true;
		} finally {
			closeSession(session);
		}
		return result;	
	}
	
	public void addTabularData(String type, String userTableName,
			String dbTableName, String description) throws SMDataPersistenceException
	 {
		
		Session session = PersistentHibernateManager.getSessionFactory().openSession();
		
		Transaction t = null;
		try {
			t = session.beginTransaction();
			User user = (User)session.get(User.class, userLogin);
			
			logger.debug("Add table metadata with info :" + 
					" user " + userLogin +
					" userTable " + userTableName +
					" dbTable " + dbTableName + 
					" dbType" + type +
					" description" + description);
					
					
			TableMetadata table = new TableMetadata(userLogin, dbTableName, userTableName,
					type, description);
			if (session.get(TableMetadata.class,
					table.getTableMetadataId()) != null) {
				logger.warn("Table exists !!!");
				throw new SMDataPersistenceException("Table exists");
			}
			
			table.setUser(user);
			session.save(table);
			
			user.getTables().add(table);
			session.update(user);
			
			t.commit();
			
		} catch (Exception e) {
			logger.error("Error in add tabular data",e);
			roolbackTransaction(t);
			throw new SMDataPersistenceException(e.getMessage());
		} finally {
			closeSession(session);			
		}
	}
	
	public SMTableMetadataList getTabularData() {
		
		Session session = PersistentHibernateManager.getSessionFactory().openSession();
		SMTableMetadata[] smTableList = null;
		try {
			User user = (User)session.get(User.class, userLogin);
			Set<TableMetadata> tables = user.getTables();

			smTableList = new SMTableMetadata[tables.size()];

			int i = 0;
			for (TableMetadata table : user.getTables()) {

				Calendar calendar = Calendar.getInstance();
				calendar.setTime(table.getCreationDate());
				smTableList[i++] = new SMTableMetadata(calendar,table.getDescription(),
						table.getTableMetadataId().getTableName(),table.getLabel(),table.getType());
			}
		} finally {
			closeSession(session);
		}
		return  new SMTableMetadataList(smTableList);
	}
	
	public SMTableMetadataList getTabularDataByTemplate(String template) {
		
		Session session = PersistentHibernateManager.getSessionFactory().openSession();
		
		SMTableMetadata[] smTableList = null;
		try {
				
			Query query = session.createQuery("select t from TableMetadata t," +
					" User u where u.username = :name and t.type = :template");
			query.setParameter("name", userLogin);
			query.setParameter("template", template);
			
			@SuppressWarnings("unchecked")
			List<Object> objects = query.list();
			smTableList = new SMTableMetadata[objects.size()];
			int i = 0;
			for (Object object : objects) {
				TableMetadata table = (TableMetadata)object; 
				Calendar calendar = Calendar.getInstance();
				calendar.setTime(table.getCreationDate());
				smTableList[i++] = new SMTableMetadata(calendar,table.getDescription(),
						table.getTableMetadataId().getTableName(),table.getLabel(),table.getType());
			}
			
			
		} finally {
			closeSession(session);
		}
		return  new SMTableMetadataList(smTableList);
	}
}
