package org.gcube.data.analysis.statisticalmanager.persistence.data;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.gcube.data.analysis.statisticalmanager.operation.OperationStatus;
import org.gcube.data.analysis.statisticalmanager.persistence.data.TabularOutput;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;

public class Computation {

	private long computationId; 
	private String category; 
	private String algorithm;

	private String description;
	private Date startDate;
	private Date endDate;
	private OperationStatus status;
	private Output output;
	private INFRASTRUCTURE infrastructure;

	public Computation() {}
	
	public Computation(String category, String algorithm,
			String description, Date startDate) {
		super ();
		
		setCategory(category);
		setAlgorithm(algorithm);		
		setDescription(description);
		setStartDate(startDate);
		setStatus(OperationStatus.PENDING);
	}

	public long getComputationId() {
		return computationId;
	}

	private void setComputationId(long id) {
		this.computationId = id;
	}

	public void setStatus(OperationStatus status) {
		
		this.status = status;
	}
	
	public OperationStatus getStatus() {
		return status;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}

	public String getDescription() {
		return description;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getCategory() {
		return category;
	}

	public void setAlgorithm(String algorithm) {
		this.algorithm = algorithm;
	}

	public String getAlgorithm() {
		return algorithm;
	}

	public void setOutput(Output output) {
		this.output = output;
	}

	public Output getOutput() {
		return output;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setInfrastructure(INFRASTRUCTURE infrastructure) {
		this.infrastructure = infrastructure;
	}

	public INFRASTRUCTURE getInfrastructure() {
		return infrastructure;
	}

}
