/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;

public class PersistentHibernateManager {
    private static GCUBELog logger = new GCUBELog(PersistentHibernateManager.class);
    private static SessionFactory sessionFactory = PersistentHibernateManager.buildSessionFactory();

    private static SessionFactory buildSessionFactory() {
        try {
            return new Configuration().configure(PersistentHibernateManager.class.getResource("hibernate.cfg.xml")).buildSessionFactory();
        }
        catch (Throwable ex) {
            logger.error((Object)("Initial SessionFactory creation failed." + ex));
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static void closeSession(Session session) {
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void roolbackTransaction(Transaction t) {
        try {
            if (t != null) {
                t.rollback();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

