/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.persistence.PersistentHibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.data.TableMetadata;
import org.gcube.data.analysis.statisticalmanager.persistence.data.TableMetadataId;
import org.gcube.data.analysis.statisticalmanager.persistence.data.User;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadata;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataList;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class UserDataSpaceManager {
    private GCUBELog logger = new GCUBELog(UserDataSpaceManager.class);
    private String userLogin;

    public UserDataSpaceManager(String userLogin) {
        this.userLogin = userLogin;
    }

    public boolean existTabularData(String tableName) {
        boolean result = false;
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        try {
            TableMetadataId tableId = new TableMetadataId(this.userLogin, tableName);
            if (session.get(TableMetadata.class, (Serializable)tableId) != null) {
                result = true;
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
        return result;
    }

    public void addTabularData(String type, String userTableName, String dbTableName, String description) throws SMDataPersistenceException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                User user = (User)session.get(User.class, (Serializable)((Object)this.userLogin));
                this.logger.debug((Object)("Add table metadata with info : user " + this.userLogin + " userTable " + userTableName + " dbTable " + dbTableName + " dbType" + type + " description" + description));
                TableMetadata table = new TableMetadata(this.userLogin, dbTableName, userTableName, type, description);
                if (session.get(TableMetadata.class, (Serializable)table.getTableMetadataId()) != null) {
                    this.logger.warn((Object)"Table exists !!!");
                    throw new SMDataPersistenceException("Table exists");
                }
                table.setUser(user);
                session.save((Object)table);
                user.getTables().add(table);
                session.update((Object)user);
                t.commit();
            }
            catch (Exception e) {
                this.logger.error((Object)"Error in add tabular data", (Throwable)e);
                PersistentHibernateManager.roolbackTransaction(t);
                throw new SMDataPersistenceException(e.getMessage());
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public SMTableMetadataList getTabularData() {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        SMTableMetadata[] smTableList = null;
        try {
            User user = (User)session.get(User.class, (Serializable)((Object)this.userLogin));
            Set<TableMetadata> tables = user.getTables();
            smTableList = new SMTableMetadata[tables.size()];
            int i = 0;
            for (TableMetadata table : user.getTables()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(table.getCreationDate());
                smTableList[i++] = new SMTableMetadata(calendar, table.getDescription(), table.getTableMetadataId().getTableName(), table.getLabel(), table.getType());
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
        return new SMTableMetadataList(smTableList);
    }

    public SMTableMetadataList getTabularDataByTemplate(String template) {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        SMTableMetadata[] smTableList = null;
        try {
            Query query = session.createQuery("select t from TableMetadata t, User u where u.username = :name and t.type = :template");
            query.setParameter("name", (Object)this.userLogin);
            query.setParameter("template", (Object)template);
            List objects = query.list();
            smTableList = new SMTableMetadata[objects.size()];
            int i = 0;
            for (Object object : objects) {
                TableMetadata table = (TableMetadata)object;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(table.getCreationDate());
                smTableList[i++] = new SMTableMetadata(calendar, table.getDescription(), table.getTableMetadataId().getTableName(), table.getLabel(), table.getType());
            }
        }
        finally {
            PersistentHibernateManager.closeSession((org.hibernate.Session)session);
        }
        return new SMTableMetadataList(smTableList);
    }
}

