/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.porttypes;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.FactoryContext;
import org.gcube.data.analysis.statisticalmanager.context.StatisticalManagerContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.home.StatisticalManagerServiceHome;
import org.gcube.data.analysis.statisticalmanager.persistence.UserHistoryManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserManager;
import org.gcube.data.analysis.statisticalmanager.stubs.FactoryPortType;
import org.gcube.data.analysis.statisticalmanager.types.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerFactoryResource;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerServiceResource;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Algorithm;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Feature;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Features;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistoryList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ParametersList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMHistoryRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMHistoryRequestByInputParameters;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTypeParameter;

public class StatisticalManagerFactory
extends GCUBEPortType
implements FactoryPortType {
    GCUBELog logger = new GCUBELog(StatisticalManagerFactory.class);
    private static final String keyFRString = "keyFactoryResource";
    private static StatisticalManagerFactoryResource resource;

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public static StatisticalManagerFactoryResource getFactoryResource() {
        return resource;
    }

    public EndpointReferenceType serviceConnect(String token) throws RemoteException, GCUBEUnrecoverableFault {
        try {
            GCUBEStatefulPortTypeContext stfctx = StatisticalManagerContext.getContext();
            GCUBEWSResourceKey key = stfctx.makeKey(token);
            StatisticalManagerServiceHome home = (StatisticalManagerServiceHome)stfctx.getWSHome();
            StatisticalManagerServiceResource wsResource = (StatisticalManagerServiceResource)home.create(key, new Object[]{token});
            return wsResource.getEPR();
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    protected void onInitialisation() throws Exception {
        if (resource != null) {
            return;
        }
        this.logger.info((Object)"Initialising the factory state...");
        new Thread(){

            @Override
            public void run() {
                int attempts = 0;
                boolean created = false;
                while (attempts++ < 10) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        StatisticalManagerFactory.this.logger.error((Object)"Failed to sleep in between factory creation");
                        ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                        break;
                    }
                    try {
                        for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                            StatisticalManagerFactory.this.logger.info((Object)("Creating the resource within the scope " + scope.getName()));
                            ServiceContext.getContext().setScope(scope);
                        }
                        resource = (StatisticalManagerFactoryResource)FactoryContext.getContext().getWSHome().create(FactoryContext.getContext().makeKey(StatisticalManagerFactory.keyFRString), new Object[0]);
                        created = true;
                        break;
                    }
                    catch (Exception e) {
                        StatisticalManagerFactory.this.logger.error((Object)"Failed to create the resource", (Throwable)e);
                    }
                }
                if (!created) {
                    ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                }
            }
        }.start();
    }

    public Features getFeatures(VOID arg0) throws RemoteException, GCUBEUnrecoverableFault {
        this.logger.debug((Object)"GET all features called");
        String configPath = ServiceContext.getContext().getProperty("configDir", new boolean[0]) + "/cfg/";
        Feature[] features = null;
        try {
            this.logger.debug((Object)"features map ....");
            HashMap mapFeatures = ProcessorsFactory.getAllFeatures((String)configPath);
            this.logger.debug((Object)"features map found");
            features = new Feature[mapFeatures.size()];
            int i = 0;
            for (Map.Entry entry : mapFeatures.entrySet()) {
                this.logger.debug((Object)("CATEGORY found " + (String)entry.getKey()));
                ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
                for (String algorithmName : (List)entry.getValue()) {
                    String description = StatisticalManagerFactory.getFactoryResource().getAgorithmDescription((String)entry.getKey(), algorithmName);
                    algorithms.add(new Algorithm(description, algorithmName));
                }
                features[i++] = new Feature(algorithms.toArray(new Algorithm[algorithms.size()]), ComputationalAgentClass.fromString((String)((String)entry.getKey())));
            }
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        return new Features(features);
    }

    public ParametersList getAlgorithmParameters(SMComputation computation) throws RemoteException, GCUBEFault {
        String algorithmDescription = null;
        List<StatisticalType> parameters = null;
        try {
            parameters = StatisticalManagerFactory.getFactoryResource().getListParameters(computation.getCategory().getValue(), computation.getAlgorithm());
            algorithmDescription = StatisticalManagerFactory.getFactoryResource().getAgorithmDescription(computation.getCategory().getValue(), computation.getAlgorithm());
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException("Parameters unknown for this computation", e).toFault(new String[0]);
        }
        this.logger.debug((Object)"------------- parameters retrieved");
        ArrayList<SMParameter> listParameters = new ArrayList<SMParameter>();
        for (StatisticalType param : parameters) {
            SMParameter smParameter = FactoryComputationParameter.createParameter(param);
            if (smParameter == null) continue;
            listParameters.add(smParameter);
        }
        return new ParametersList(algorithmDescription, listParameters.toArray(new SMParameter[listParameters.size()]));
    }

    public Features getFeaturesForInputParameters(SMTypeParameter typeParameter) throws RemoteException, GCUBEFault {
        String configPath = StatisticalManagerFactory.getFactoryResource().getConfigPath();
        ArrayList<Feature> features = new ArrayList<Feature>();
        try {
            HashMap mapFeatures = ProcessorsFactory.getAllFeatures((String)configPath);
            for (Map.Entry entry : mapFeatures.entrySet()) {
                String category = (String)entry.getKey();
                Feature feature = new Feature();
                feature.setCategory(ComputationalAgentClass.fromString((String)category));
                ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
                for (String algorithmName : (List)entry.getValue()) {
                    List<StatisticalType> parameters = StatisticalManagerFactory.getFactoryResource().getListParameters(category, algorithmName);
                    if (!FactoryComputationParameter.containParameter(typeParameter, parameters)) continue;
                    String description = StatisticalManagerFactory.getFactoryResource().getAgorithmDescription(category, algorithmName);
                    algorithms.add(new Algorithm(description, algorithmName));
                }
                if (algorithms.isEmpty()) continue;
                feature.setAlgorithms(algorithms.toArray(new Algorithm[algorithms.size()]));
                features.add(feature);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Get feature for input parameters ", (Throwable)e);
        }
        if (!features.isEmpty()) {
            return new Features(features.toArray(new Feature[features.size()]));
        }
        return new Features(new Feature[0]);
    }

    public ItemHistoryList getUserHistory(SMHistoryRequest request) throws RemoteException, GCUBEFault {
        try {
            UserHistoryManager historyManager = new UserManager(request.getUser()).getUserHistoryManager();
            return historyManager.getUserHistory(request);
        }
        catch (StatisticalManagerException e) {
            throw this.getServiceContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public ItemHistoryList getUserHistoryByTypeParameters(SMHistoryRequestByInputParameters request) throws RemoteException, GCUBEFault {
        try {
            UserHistoryManager historyManager = new UserManager(request.getUser()).getUserHistoryManager();
            ArrayList<Feature> features = new ArrayList<Feature>();
            HashMap mapFeatures = ProcessorsFactory.getAllFeatures((String)StatisticalManagerFactory.getFactoryResource().getConfigPath());
            for (Map.Entry entry : mapFeatures.entrySet()) {
                String category = (String)entry.getKey();
                Feature feature = new Feature();
                feature.setCategory(ComputationalAgentClass.fromString((String)category));
                ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
                SMTypeParameter[] sMTypeParameterArray = request.getParameter();
                int n = sMTypeParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SMTypeParameter typeParameter = sMTypeParameterArray[n2];
                    for (String algorithm : (List)entry.getValue()) {
                        List<StatisticalType> parameters = StatisticalManagerFactory.getFactoryResource().getListParameters(category, algorithm);
                        if (!FactoryComputationParameter.containParameter(typeParameter, parameters)) continue;
                        algorithms.add(new Algorithm(null, algorithm));
                    }
                    ++n2;
                }
                if (algorithms.isEmpty()) continue;
                feature.setAlgorithms(algorithms.toArray(new Algorithm[algorithms.size()]));
                features.add(feature);
            }
            ArrayList result = new ArrayList();
            for (Feature feature : features) {
                Algorithm[] algorithmArray = feature.getAlgorithms();
                int n = algorithmArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Algorithm algorithm = algorithmArray[n3];
                    ItemHistoryList list = historyManager.getUserHistory(new SMHistoryRequest(algorithm.getName(), feature.getCategory().toString(), request.getUser()));
                    result.addAll(Arrays.asList((Object[])list.getList()));
                    ++n3;
                }
            }
            return new ItemHistoryList(result.toArray(new ItemHistory[result.size()]));
        }
        catch (Exception e) {
            throw this.getServiceContext().getDefaultException(e).toFault(new String[0]);
        }
    }
}

