/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.wsresources;

import java.io.File;
import java.net.URI;
import java.util.Calendar;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.data.analysis.statisticalmanager.db.DataSourceManager;
import org.gcube.data.analysis.statisticalmanager.operation.OperationStatus;
import org.gcube.data.analysis.statisticalmanager.operation.converter.CSVConverter;
import org.gcube.data.analysis.statisticalmanager.operation.converter.OccurrenceStreamConverter;
import org.gcube.data.analysis.statisticalmanager.operation.exception.SMFileManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.UserManager;
import org.gcube.data.analysis.statisticalmanager.util.RSWrapper;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.CSVtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.DataStreamtoTabularRequest;

public class DataSpaceImporterResource
extends GCUBEWSResource {
    private String user = null;
    private volatile String objectId = null;
    private volatile OperationStatus status = OperationStatus.PENDING;
    private volatile Calendar creationDate;
    private volatile String description;
    private volatile String objectType;
    private volatile String objectLabel;
    private volatile Calendar startImport;

    protected void initialise(Object ... params) throws Exception {
        this.user = (String)params[0];
    }

    public void createTableFromCSV(final CSVtoTabularRequest request) throws SMFileManagerException {
        this.setStatus(OperationStatus.RUNNING);
        this.setDescription(request.getDescription());
        this.setObjectType(request.getTableType());
        this.setObjectLabel(request.getTableName());
        this.setStartImport(Calendar.getInstance());
        Thread th = new Thread(){

            @Override
            public void run() {
                try {
                    File file = RSWrapper.getStreamFromLocator(new URI(request.getRsLocator()));
                    DataSpaceImporterResource.this.logger.debug((Object)("File path :" + file.getAbsolutePath()));
                    CSVConverter converter = new CSVConverter(file.getAbsolutePath(), request.isHasHeader(), request.getTableName(), request.getTableType());
                    String dbTableName = converter.toTabularData();
                    UserManager userManager = new UserManager(DataSpaceImporterResource.this.user);
                    userManager.getUserdaDataSpaceManager().addTabularData(request.getTableType(), request.getTableName(), dbTableName, request.getDescription());
                    DataSpaceImporterResource.this.objectId = dbTableName;
                    DataSpaceImporterResource.this.setCreationDate(Calendar.getInstance());
                    DataSpaceImporterResource.this.setStatus(OperationStatus.COMPLETED);
                }
                catch (Exception e) {
                    DataSpaceImporterResource.this.setStatus(OperationStatus.FAILED);
                    DataSpaceImporterResource.this.logger.error((Object)"CSV importer error ", (Throwable)e);
                }
            }
        };
        th.start();
    }

    public void createTableFromDataStream(final DataStreamtoTabularRequest request) {
        this.logger.debug((Object)"start table creation");
        this.setStatus(OperationStatus.RUNNING);
        Thread th = new Thread(){

            @Override
            public void run() {
                try {
                    OccurrenceStreamConverter converter = new OccurrenceStreamConverter(DataSourceManager.getDataSource(), request.getRsLocator());
                    converter.run();
                    UserManager userManager = new UserManager(DataSpaceImporterResource.this.user);
                    userManager.getUserdaDataSpaceManager().addTabularData(request.getTableType(), request.getTableName(), converter.getTableName(), request.getDescription());
                    DataSpaceImporterResource.this.objectId = converter.getTableName();
                    DataSpaceImporterResource.this.setStatus(OperationStatus.COMPLETED);
                }
                catch (Exception e) {
                    DataSpaceImporterResource.this.setStatus(OperationStatus.FAILED);
                    DataSpaceImporterResource.this.logger.error((Object)"DataStream importer error ", (Throwable)e);
                }
            }
        };
        th.start();
    }

    private void setStatus(OperationStatus status) {
        this.status = status;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public String getUser() {
        return this.user;
    }

    public String getObjectId() {
        return this.objectId;
    }

    private void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectType() {
        return this.objectType;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    private void setObjectLabel(String objectLabel) {
        this.objectLabel = objectLabel;
    }

    public String getObjectLabel() {
        return this.objectLabel;
    }

    private void setStartImport(Calendar startImport) {
        this.startImport = startImport;
    }

    public Calendar getStartImport() {
        return this.startImport;
    }

    private void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }
}

