package org.gcube.data.analysis.statisticalmanager.proxies;

import static org.gcube.data.streams.dsl.Streams.publish;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.gcore.Utils;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpacePortType;
import org.gcube.data.analysis.statisticalmanager.stubs.FactoryPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImportersRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.StatisticalServicePortType;
import org.gcube.data.analysis.statisticalmanager.wrapper.RSWrapper;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.binding.Bindings;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.publishers.RecordFactory;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.CSVtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.DataStreamtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ParametersList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataRequest;

public class StatisticalManagerDefaultDataSpace implements StatisticalManagerDataSpace {
	

	private final AsyncProxyDelegate<DataSpacePortType> delegate;
	
	public StatisticalManagerDefaultDataSpace(ProxyDelegate<DataSpacePortType> delegate) {
		super();
		this.delegate = new AsyncProxyDelegate<DataSpacePortType>(delegate);
	}

	@Override
	public SMTableMetadataList getTableMetadata(final String user) {
		
		Call<DataSpacePortType, SMTableMetadataList> call = new Call<DataSpacePortType, SMTableMetadataList>(){
			
			@Override
			public SMTableMetadataList call(DataSpacePortType endpoint) throws Exception {
				return endpoint.getTableMetadata(new SMTableMetadataRequest(null,user));
				};
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}
	
	@Override
	public W3CEndpointReference createTableFromCSV(File file, final boolean hasHeader, final String tableName,
			final TableTemplates tableTemplate, final String description, final String user) {
		
		String scope = ScopeProvider.instance.get();
		try {
			RSWrapper wrapper = new RSWrapper(GCUBEScope.getScope(scope));
			wrapper.add(file);
			final String locator = wrapper.getLocator().toString();
				
			Call<DataSpacePortType, W3CEndpointReference> call = new Call<DataSpacePortType, W3CEndpointReference>() {
				@Override
				public W3CEndpointReference call(DataSpacePortType endpoint)
				throws Exception {
					return Utils.convert(endpoint.createTableFromCSV(new CSVtoTabularRequest(description,hasHeader,locator,
							tableName,tableTemplate.toString(),user)));
				}	
			};
			
			return delegate.make(call);
		}  catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
				
	}

	@Override
	public W3CEndpointReference createTableFromDataStream(Stream<OccurrencePoint> points, final String tableName,
			final String description, final String user)  {
		
		
		final URI rs = publish(points).using(new RecordFactory<OccurrencePoint>() {
			
			@Override
			public Record newRecord(OccurrencePoint element)
					throws RuntimeException {
				
				GenericRecord gr=new GenericRecord();
				try {
					gr.setFields(new StringField[]{new StringField(Bindings.toXml(element))});
				} catch (Exception e) {
					throw new RuntimeException(e); 
				}
				
				return gr;
			}
			
			@Override
			public RecordDefinition[] definitions() {
				StringFieldDefinition fieldDefinition = new StringFieldDefinition("result");
				RecordDefinition[] defs=new RecordDefinition[]{          //A gRS can contain a number of different record definitions
				        new GenericRecordDefinition((new FieldDefinition[] { //A record can contain a number of different field definitions
				        		fieldDefinition				        //The definition of the field
				      }))
				    };
				return defs;
			}

			
		}).withDefaults();
		
		Call<DataSpacePortType, W3CEndpointReference> call = new Call<DataSpacePortType, W3CEndpointReference>() {
			@Override
			public W3CEndpointReference call(DataSpacePortType endpoint)
			throws Exception {
				return Utils.convert(endpoint.createTableFromDataStream(new DataStreamtoTabularRequest(description,
						rs.toString(), tableName, TableTemplates.OCCURRENCE_SPECIES.toString(), user)));
			}	
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public String getDBParameters(final String tableId) {
		
		Call<DataSpacePortType, String> call = new Call<DataSpacePortType, String>() {
			@Override
			public String call(DataSpacePortType endpoint)
			throws Exception {
				return endpoint.getDBParameters(tableId);
			}	
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public SMTableMetadataList getTableMetadata(final String user,final String template) {
			
			Call<DataSpacePortType, SMTableMetadataList> call = new Call<DataSpacePortType, SMTableMetadataList>(){
				
				@Override
				public SMTableMetadataList call(DataSpacePortType endpoint) throws Exception {
					return endpoint.getTableMetadata(new SMTableMetadataRequest(template, user));
					};
			};
			
			try {
				return delegate.make(call);
			} catch (Exception e) {
				throw FaultDSL.again(e).asServiceException();
			}
		}

	@Override
	public List<W3CEndpointReference> getImporters(final String user,final String template) {
		
		Call<DataSpacePortType, SMImporters> call = new Call<DataSpacePortType, SMImporters>(){
			
			@Override
			public SMImporters call(DataSpacePortType endpoint) throws Exception {
				return endpoint.getImporters(new SMImportersRequest(template, user));
				};
		};
		
		try {
			SMImporters importers =  delegate.make(call);
			ArrayList<W3CEndpointReference> list = new ArrayList<W3CEndpointReference>();
			if (importers.getList() != null) {
				for (EndpointReferenceType epr : importers.getList()) {
					list.add(Utils.convert(epr));
				}
			}
			return list;
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}



}

	
