/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.shared.process;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorCategory;

public class OperatorsClassification
implements Serializable {
    private static final long serialVersionUID = 7347445659350838584L;
    private String name;
    private List<OperatorCategory> operatorCategories = new ArrayList<OperatorCategory>();
    private List<Operator> operators = new ArrayList<Operator>();

    public OperatorsClassification() {
    }

    public OperatorsClassification(String name) {
        this.name = name;
    }

    public OperatorsClassification(String name, List<OperatorCategory> operatorCategories, List<Operator> operators) {
        this(name);
        this.operatorCategories = operatorCategories;
        this.operators = operators;
    }

    public List<OperatorCategory> getOperatorCategories() {
        return this.operatorCategories;
    }

    public void setOperatorCategories(List<OperatorCategory> operatorCategories) {
        this.operatorCategories = operatorCategories;
    }

    public List<Operator> getOperators() {
        return this.operators;
    }

    public void setOperators(List<Operator> operators) {
        this.operators = operators;
    }

    public Operator getOperatorById(String id) {
        if (id == null) {
            return null;
        }
        Operator operator = null;
        for (Operator op : this.operators) {
            if (!op.getId().contentEquals(id)) continue;
            operator = op;
            break;
        }
        return operator;
    }

    public OperatorCategory getCategoryById(String id) {
        OperatorCategory category = null;
        for (OperatorCategory cat : this.operatorCategories) {
            if (!cat.getId().contentEquals(id)) continue;
            category = cat;
            break;
        }
        return category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "OperatorsClassification [name=" + this.name + ", operatorCategories=" + this.operatorCategories + ", operators=" + this.operators + "]";
    }
}

