/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.gcube.data.analysis.dminvocation.DataMinerInvocationManager;
import org.gcube.data.analysis.dminvocation.model.DataMinerInvocation;
import org.gcube.data.analysis.dminvocation.model.DataMinerParam;
import org.gcube.data.analysis.dminvocation.model.DataMinerParamList;
import org.gcube.data.analysis.dminvocation.model.DataMinerParameters;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

public class DataMinerInvocationTest {
    static String operatorID = "[THE_OPERATOR_ID]";
    static Map<String, String> parameters = new HashMap<String, String>();
    static DataMinerInvocationManager dmMng;

    @Before
    public void init() throws JAXBException, IOException, SAXException {
        parameters.put("fileId", "http://publicLinkToFile");
        parameters.put("[key2]", "[value2]");
        dmMng = DataMinerInvocationManager.getInstance();
    }

    public void marshallingTest() throws JAXBException, IOException, SAXException {
        System.out.println("marshallingTest called");
        ArrayList<DataMinerParam> inParams = new ArrayList<DataMinerParam>();
        for (String pm : parameters.keySet()) {
            inParams.add(new DataMinerParam(pm, parameters.get(pm)));
        }
        DataMinerParameters parameters = new DataMinerParameters(new DataMinerParamList(inParams), null);
        DataMinerInvocation dmInvocation = new DataMinerInvocation();
        dmInvocation.setOperatorId(operatorID);
        dmInvocation.setParameters(parameters);
        System.out.println(dmInvocation);
        String marshXML = dmMng.marshalingXML(dmInvocation, true, true);
        System.out.println(marshXML);
        String marshJSON = dmMng.marshalingJSON(dmInvocation, true, true);
        System.out.println(marshJSON);
    }

    public void marshallingTest2() throws JAXBException, IOException, SAXException {
        System.out.println("marshallingTest called");
        ArrayList<DataMinerParam> inParams = new ArrayList<DataMinerParam>();
        for (String pm : parameters.keySet()) {
            inParams.add(new DataMinerParam(pm, parameters.get(pm)));
        }
        DataMinerParameters parameters = new DataMinerParameters(new DataMinerParamList(inParams), null);
        DataMinerInvocation dmInvocation = new DataMinerInvocation();
        String marshJSON = dmMng.marshalingJSON(dmInvocation, true, true);
        System.out.println(marshJSON);
    }

    public void unmarshallingXMLTest() throws JAXBException, IOException, SAXException {
        System.out.println("unmarshallingXMLTest called");
        FileInputStream dmInvocationXMLFile = new FileInputStream(new File("./src/test/resources/DataMinerInvocation.xml"));
        DataMinerInvocation dmInvocation = dmMng.unmarshalingXML((InputStream)dmInvocationXMLFile, true);
        System.out.println(dmInvocation);
        String marshXML = dmMng.marshalingXML(dmInvocation, true, true);
        System.out.println("TO XML: \n" + marshXML);
        String marshJSON = dmMng.marshalingJSON(dmInvocation, true, true);
        System.out.println("TO JSON: \n" + marshJSON);
    }

    @Test
    public void unmarshallingJSONTest() throws JAXBException, IOException, SAXException {
        System.out.println("unmarshallingJSONTest called");
        FileInputStream dmInvocationJSONFile = new FileInputStream(new File("./src/test/resources/DataMinerInvocation.json"));
        DataMinerInvocation dmInvocation = dmMng.unmarshalingJSON((InputStream)dmInvocationJSONFile, true);
        System.out.println(dmInvocation);
        String marshXML = dmMng.marshalingXML(dmInvocation, true, true);
        System.out.println("TO XML: \n" + marshXML);
        String marshJSON = dmMng.marshalingJSON(dmInvocation, true, true);
        System.out.println("TO JSON: \n" + marshJSON);
    }
}

