/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.gtuploader;

import com.terradue.gtuploader.BoundingBox;
import com.terradue.gtuploader.Store;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="coverage")
public final class Coverage {
    private static final String DEFAULT_SRS = "EPSG:4326";
    private String name;
    private String title;
    private String workspace;
    private BoundingBox nativeBoundingBox;
    private BoundingBox latLonBoundingBox;
    private Store store;

    @XmlElement(name="abstract")
    public String getAbstract() {
        return String.format("Generated from session %s on %s", this.workspace, new Date());
    }

    @XmlElement(name="nativeCRS")
    public String getNativeCRS() {
        return DEFAULT_SRS;
    }

    @XmlElement(name="srs")
    public String getSRS() {
        return DEFAULT_SRS;
    }

    @XmlElement(name="enabled")
    public boolean isEnabled() {
        return true;
    }

    public String toString() {
        return "Coverage(name=" + this.getName() + ", title=" + this.getTitle() + ", workspace=" + this.workspace + ", nativeBoundingBox=" + this.getNativeBoundingBox() + ", latLonBoundingBox=" + this.getLatLonBoundingBox() + ")";
    }

    @XmlElement(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    @XmlElement(name="nativeBoundingBox")
    public BoundingBox getNativeBoundingBox() {
        return this.nativeBoundingBox;
    }

    public void setNativeBoundingBox(BoundingBox nativeBoundingBox) {
        nativeBoundingBox.setCrs(DEFAULT_SRS);
        this.nativeBoundingBox = nativeBoundingBox;
    }

    @XmlElement(name="latLonBoundingBox")
    public BoundingBox getLatLonBoundingBox() {
        return this.latLonBoundingBox;
    }

    public void setLatLonBoundingBox(BoundingBox latLonBoundingBox) {
        latLonBoundingBox.setCrs(DEFAULT_SRS);
        this.latLonBoundingBox = latLonBoundingBox;
    }

    @XmlElement(name="store")
    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }
}

