/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.data.analysis.nlphub.legacy.JsonManager;
import org.gcube.data.analysis.nlphub.nlp.RunnerCommander;
import org.gcube.data.analysis.nlphub.session.SessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(asyncSupported=true, name="NLPServlet", urlPatterns={"/nlphub-servlet"})
public class NLPHub
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NLPHub.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doWork(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doWork(request, response);
    }

    private void doWork(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("NLPHub");
        SessionUtils sessionUtils = new SessionUtils();
        String token = sessionUtils.getToken(request);
        if (request.getParameter("getInfo") != null) {
            this.getAlgorithmInfo(request, response, token);
        } else {
            this.runAlgorithms(request, response, token);
        }
        logger.debug("NLPHub work done");
    }

    private void getAlgorithmInfo(HttpServletRequest request, HttpServletResponse response, String token) throws ServletException {
        try (PrintWriter writer = null;){
            logger.info("GetAlgorithmInfo");
            String dataMiner = request.getParameter("dataminer");
            String algId = request.getParameter("algId");
            logger.debug("NLPHub getAlgorithmInfo: [DataMiner=" + dataMiner + ", algorithmID=" + algId + "]");
            String algoLink = "https://services.d4science.org/group/rprototypinglab/data-miner?OperatorId=";
            algoLink = algoLink + algId;
            logger.debug("Algorithm link: " + algoLink);
            writer = response.getWriter();
            response.setContentType("application/json;charset=UTF-8");
            writer.println(new JsonManager().getSuccessJsonResponse(algoLink));
        }
    }

    private void runAlgorithms(HttpServletRequest request, HttpServletResponse response, String token) throws ServletException, IOException {
        try {
            String dataMiner = request.getParameter("dataminer");
            Object[] algs = request.getParameter("algs").split(",");
            String plink = request.getParameter("plink");
            String annotations = request.getParameter("annotations");
            logger.debug("NLPHub getAlgorithmInfo: [DataMiner=" + dataMiner + ", plink=" + plink + ", annotations=" + annotations + ", algorithms=" + Arrays.toString(algs) + "]");
            for (int i = 0; i < algs.length; ++i) {
                algs[i] = ((String)algs[i]).trim();
            }
            String maxWaitingTime = this.getServletConfig().getInitParameter("MaxWaitingTime");
            String sleepTime = this.getServletConfig().getInitParameter("SleepTime");
            logger.debug("NLPHub: [maxWaitingTime=" + maxWaitingTime + ", sleepTime=" + sleepTime + "]");
            long maxWaitingTimeL = Long.parseLong(maxWaitingTime);
            long sleepTimeL = Long.parseLong(sleepTime);
            RunnerCommander commander = new RunnerCommander(dataMiner, (String[])algs, plink, annotations, token, response);
            commander.setSleepTime(sleepTimeL);
            commander.setMaxWaitingTime(maxWaitingTimeL);
            commander.startProcess();
        }
        catch (Exception e) {
            logger.error("NLPHub runAlgorithms: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

