/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.gcube.data.analysis.sdmx.datasource.data.ResultSetExtractor;
import org.gcube.data.analysis.sdmx.datasource.data.ResultSetExtractorAbstractImpl;
import org.gcube.data.analysis.sdmx.datasource.series.model.ObservationModel;
import org.gcube.data.analysis.sdmx.datasource.series.model.SeriesModel;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeManagerResultSetExtractor
extends ResultSetExtractorAbstractImpl
implements ResultSetExtractor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private SeriesModel getSeriesModel(String serieKeyValue, ResultSet rs) throws SQLException {
        SeriesModel seriesModel = (SeriesModel)this.seriesModelMap.get(serieKeyValue);
        if (seriesModel == null) {
            seriesModel = this.generateNewSeriesModel(rs);
            this.seriesModelMap.put(serieKeyValue, seriesModel);
        }
        return seriesModel;
    }

    public void processRows(ResultSet rs) throws SQLException {
        this.logger.debug("Processing rows");
        this.logger.debug("Series key column " + this.seriesKeyColumn);
        while (rs.next()) {
            String serieKeyValue = rs.getString(this.seriesKeyColumn);
            this.logger.debug("Series key value " + serieKeyValue);
            SeriesModel seriesModel = this.getSeriesModel(serieKeyValue, rs);
            ObservationModel observation = new ObservationModel();
            String observationTime = rs.getString(this.observationTimeColumn);
            String observationValue = rs.getString(this.observationValueColumn);
            this.logger.debug("Adding observation of " + observationTime + " = " + observationValue);
            observation.setId(observationTime);
            observation.setValue(observationValue);
            this.logger.debug("Adding observation attributes");
            for (AttributeBean attr : this.dsd.getObservationAttributes("TIME_PERIOD")) {
                String observationAttributeID = attr.getId();
                String observationAttributeColumn = this.getColumnLabel(observationAttributeID, this.attributeColumnMap);
                String observationAttributeValue = rs.getString(observationAttributeColumn);
                if (observationAttributeValue != null) {
                    this.logger.debug("Observation Attribute id " + observationAttributeID + " value " + observationAttributeValue);
                    observation.addAttribute(observationAttributeID, observationAttributeValue);
                    continue;
                }
                this.logger.warn("Time dimension fixed id attribute not found");
            }
            seriesModel.addObservations(observation);
        }
    }

    private SeriesModel generateNewSeriesModel(ResultSet rs) throws SQLException {
        this.logger.debug("New series key, adding dimensions");
        SeriesModel response = new SeriesModel();
        this.logger.debug("Adding generic dimensions");
        for (DimensionBean dim : this.dsd.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION})) {
            String dimensionID = dim.getId();
            String columnValue = this.getColumnLabel(dimensionID, this.dimensionColumnMap);
            String dimensionValue = rs.getString(columnValue);
            if (dimensionValue != null) {
                this.logger.debug("Database value " + dimensionValue);
                response.addSeriesDimensions(dimensionID, dimensionValue);
                continue;
            }
            this.logger.warn("Dimension not found");
        }
        for (DimensionBean measureDimension : this.dsd.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION})) {
            String measureDimensionID = measureDimension.getId();
            this.logger.debug("Data structure measure dimension id = " + measureDimensionID);
            String measureColumnValue = this.getColumnLabel(measureDimensionID, this.dimensionColumnMap);
            String measureDimensionValue = rs.getString(measureColumnValue);
            if (measureDimensionValue != null) {
                this.logger.debug("Database value " + measureDimensionValue);
                response.addSeriesDimensions(measureColumnValue, measureDimensionValue);
                continue;
            }
            this.logger.warn("Dimension not found");
        }
        this.logger.debug("Adding time dimension attributes");
        for (AttributeBean attr : this.dsd.getSeriesAttributes("TIME_PERIOD")) {
            String attributeID = attr.getId();
            String attributeColumn = this.getColumnLabel(attributeID, this.attributeColumnMap);
            this.logger.debug("Attribute id " + attributeID + " attribute column " + attributeColumn);
            String attributeValue = rs.getString(attributeColumn);
            if (attributeValue != null) {
                this.logger.debug("Attribute value " + attributeValue);
                response.addSeriesAttributes(attributeID, attributeValue);
                continue;
            }
            this.logger.warn("Attribute not found");
        }
        return response;
    }

    private String getColumnLabel(String componentId, Map<String, String> map) {
        this.logger.debug("Getting column value for " + componentId);
        String columnValue = map.get(componentId);
        if (columnValue == null) {
            this.logger.warn("Column value not found, using component id");
            columnValue = componentId;
        }
        this.logger.debug("Response value " + columnValue);
        return columnValue;
    }
}

