/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.sdmx.datasource.cubemanager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.CubeManagerDataRetriever;
import org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.impl.CubeManagerDataRetrieverImpl;
import org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.impl.CubeManagerQuery;
import org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.impl.CubeManagerResultSetExtractor;
import org.gcube.data.analysis.sdmx.datasource.data.DataRetrievalManager;
import org.gcube.data.analysis.sdmx.datasource.data.DataRetrieverFactory;
import org.gcube.data.analysis.sdmx.datasource.data.utils.SdmxDataWriter;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeManagerRetrievalManager
implements DataRetrievalManager<CubeManagerDataRetriever> {
    private Map<String, DataRetrieverFactory<CubeManagerDataRetriever>> dataRetrieverFactoryMap;
    @Inject
    private CubeManager cubeManager;
    @Inject
    private DatabaseConnectionProvider connectionProvider;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEFAULT_DATA_RETRIEVER = "DEFAULT";

    public CubeManagerRetrievalManager() {
        this.dataRetrieverFactoryMap = new HashMap();
    }

    public void setDataRetrieverFactoryMap(Map<String, DataRetrieverFactory<CubeManagerDataRetriever>> dataRetrieverFactoryMap) {
        this.dataRetrieverFactoryMap = dataRetrieverFactoryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData(DataQuery dataQuery, DataWriterEngine dataWriter) {
        this.logger.debug("Loading table by using cube manager");
        String dataStructureid = dataQuery.getDataStructure().getId();
        this.logger.debug("Data structure id " + dataStructureid);
        CubeManagerDataRetriever dataRetriever = this.getDataRetriever(dataStructureid);
        CubeManagerQuery query = (CubeManagerQuery)dataRetriever.generateQueryBuilder().buildDataQuery(dataQuery);
        query.generateQuery(this.cubeManager);
        this.logger.debug("Query generated");
        this.logger.debug("Adding SDMX elements to rs extractor");
        this.logger.debug("Data Writer " + dataWriter.getClass());
        this.logger.debug("Data Query " + dataQuery);
        CubeManagerResultSetExtractor resultSetExtractor = (CubeManagerResultSetExtractor)dataRetriever.generateResultSetExtractor();
        HashMap seriesModelMap = new HashMap();
        resultSetExtractor.setSdmxModelElements(dataQuery.getDataStructure(), seriesModelMap);
        String queryString = query.getStatement();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.connectionProvider.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(queryString);
            resultSetExtractor.processRows(rs);
            SdmxDataWriter dataRetrieval = new SdmxDataWriter(dataQuery);
            dataRetrieval.setDataWriter(dataWriter);
            dataRetrieval.writeData(seriesModelMap);
        }
        catch (SQLException e) {
            try {
                this.logger.error("Unable to get the data", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Connection)conn);
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
    }

    private CubeManagerDataRetriever getDataRetriever(String dsdId) {
        this.logger.debug("Getting specific data retriever");
        CubeManagerDataRetriever response = null;
        DataRetrieverFactory responseFactory = (DataRetrieverFactory)this.dataRetrieverFactoryMap.get(dsdId);
        if (responseFactory == null) {
            responseFactory = (DataRetrieverFactory)this.dataRetrieverFactoryMap.get("DEFAULT");
        }
        if (responseFactory == null) {
            this.logger.warn("No data retriever factory found: trying with default tabman data retriever implementation");
            response = new CubeManagerDataRetrieverImpl();
        } else {
            response = (CubeManagerDataRetriever)responseFactory.generateDataRetriever(dsdId);
        }
        return response;
    }
}

