/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.factory.impl;

import org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.CubeManagerDataRetriever;
import org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.factory.impl.CubeManagerDataRetrieverFactoryDatabaseImpl;
import org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.impl.CubeManagerDataRetrieverImpl;
import org.gcube.data.analysis.sdmx.datasource.data.DataRetrieverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class CubeManagerDataRetrieverFactoryDatabaseImpl
extends JdbcDaoSupport
implements DataRetrieverFactory<CubeManagerDataRetriever> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String CONFIGURATION_TABLE = "TABMAN_DATA_STRUCTURE";
    private final String KEY_NAME = "DSD_ID";

    public CubeManagerDataRetriever generateDataRetriever(String dsdId) {
        CubeManagerDataRetrieverImpl cubeManagerDataRetriever = new CubeManagerDataRetrieverImpl();
        this.initDataRetriever(cubeManagerDataRetriever, dsdId);
        return cubeManagerDataRetriever;
    }

    public void initDataRetriever(CubeManagerDataRetrieverImpl dataRetriever, String dsdId) {
        this.logger.debug("Loading configuration data");
        StringBuilder queryBuilder = new StringBuilder("select * from ");
        queryBuilder.append("\"").append("TABMAN_DATA_STRUCTURE").append("\"").append(" where ").append("\"").append("DSD_ID").append("\"").append(" = ?");
        String query = queryBuilder.toString();
        this.logger.debug("Configuration query " + query);
        ConfigurationDataRetriever configurationDataRetriever = new ConfigurationDataRetriever(this);
        super.getJdbcTemplate().query(query, new Object[]{dsdId}, (RowCallbackHandler)configurationDataRetriever);
        String seriesKey = configurationDataRetriever.seriesKey;
        if (seriesKey != null && seriesKey.trim().length() > 0) {
            dataRetriever.setSeriesKeyColumn(seriesKey);
        }
        dataRetriever.setObservationTimeColumn(configurationDataRetriever.observationTime);
        dataRetriever.setObservationValueColumn(configurationDataRetriever.observationValue);
        dataRetriever.setTableId(configurationDataRetriever.tableId);
        dataRetriever.setAttributesColumnMap(configurationDataRetriever.attributesMap);
        dataRetriever.setDimensionsColumnMap(configurationDataRetriever.dimensionsMap);
    }
}

