package org.gcube.data.analysis.statisticalmanager.proxies;

import java.io.File;
import java.util.List;

import org.gcube.common.core.types.VOID;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImportersRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTables;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.streams.Stream;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMImport;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadata;

public interface StatisticalManagerDataSpace {
	
	SMTables getTables(String user);
	
	SMTables getTables(String user, String template);
	
	String getDBParameters(String tableId);
	
	String createTableFromCSV(File file, boolean hasHeader, String delimiter, String comment, String tableName,
			TableTemplates tableTemplate, String description, String user);

	String createTableFromDataStream(Stream<OccurrencePoint> points,
			String tableName, String description, String user);
	
	SMImporters getImporters(String user, String template);
	
	SMImport getImporter(String importerId);
	
	void removeImport(String importerId);
	
	List<SMTableMetadata> getTablesMetadata(String user, String... template);
	
	void checkImport(String importId);
	
	List<SMImport> getUncheckedImports(String user);
	
	void removeTable(String tableId);
	
	File exportTable(String tableId);

}
