package org.gcube.data.analysis.statisticalmanager.proxies;

import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMTypeParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMComputation;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMOperationInfo;


public interface StatisticalManagerFactory {
	
	SMListGroupedAlgorithms getAlgorithms(SMTypeParameter... typeParameters);
	
	SMListGroupedAlgorithms getAlgorithmsUser(SMTypeParameter... typeParameters);

	SMParameters getAlgorithmParameters(String algorithm); 

	SMOperationInfo getComputationInfo(String computationId, String user);
	
	SMComputation getComputation(String computationId);
	
	void removeComputation(String computationId);
	
	SMComputations getComputations(String user,
			SMTypeParameter... typeParameters);
	
	String executeComputation(SMComputationRequest requestComputation);
	
	String resubmitComputation(String computationId);
				

}
