/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.proxies;

import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerService;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationFactoryStub;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMAlgorithmsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMOutput;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMTypeParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMComputation;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMOperationInfo;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StatisticalManagerDefaultFactory
implements StatisticalManagerFactory {
    private final AsyncProxyDelegate<ComputationFactoryStub> delegate;

    public StatisticalManagerDefaultFactory(ProxyDelegate<ComputationFactoryStub> delegate) {
        this.delegate = new AsyncProxyDelegate(delegate);
    }

    private Element key(String namespace, String value) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            String keyElementPrefix = "key";
            String keyElement = "ResourceKey";
            Document document = factory.newDocumentBuilder().newDocument();
            Element key = document.createElementNS(namespace, keyElementPrefix + ":" + keyElement);
            key.setAttribute("xmlns:" + keyElementPrefix, namespace);
            key.appendChild(document.createTextNode(value));
            return key;
        }
        catch (Exception e) {
            throw new RuntimeException("programming error in AddressingUtils#key");
        }
    }

    private W3CEndpointReference getEPRComputationResourceFW(String computationId) {
        W3CEndpointReference epr = null;
        try {
            XQuery query = ICFactory.queryFor(ServiceInstance.class);
            URI u = new URI("http://gcube-system.org/namespaces/data/analysis/statisticalmanager");
            query.addNamespace("sm", u);
            query.addCondition("$resource/Data/gcube:ServiceName/text() eq 'statistical-manager-gcubews'").addCondition("$resource/Data//sm:computation/text() eq '" + computationId + "'");
            DiscoveryClient clients = ICFactory.clientFor(ServiceInstance.class);
            List props = clients.submit((Query)query);
            if (props != null && props.size() != 0) {
                W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
                Iterator i$ = props.iterator();
                if (i$.hasNext()) {
                    ServiceInstance s = (ServiceInstance)i$.next();
                    System.out.println(props);
                    ServiceInstance.Properties ps = s.properties();
                    Element key = this.key("http://gcube-system.org/namespaces/data/analysis/statisticalmanager", s.key());
                    builder.referenceParameter(key);
                    builder.address(s.endpoint().toString());
                    return builder.build();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return epr;
    }

    @Override
    public SMListGroupedAlgorithms getAlgorithms(SMTypeParameter ... typeParameters) {
        SMTypeParameter[] list = typeParameters;
        final SMAlgorithmsRequest request = new SMAlgorithmsRequest(Arrays.asList(list));
        Call<ComputationFactoryStub, SMListGroupedAlgorithms> call = new Call<ComputationFactoryStub, SMListGroupedAlgorithms>(){

            public SMListGroupedAlgorithms call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.getAlgorithms(request);
            }
        };
        try {
            return (SMListGroupedAlgorithms)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public SMOperationInfo getComputationInfo(String computationId, String user) {
        W3CEndpointReference epr = this.getEPRComputationResourceFW(computationId);
        if (epr == null) {
            SMComputation computation = this.getComputation(computationId);
            SMOperationInfo info = new SMOperationInfo();
            int index = computation.operationStatus();
            info.status(index);
            info.percentage(String.valueOf(0));
            switch (SMOperationStatus.values()[index]) {
                case COMPLETED: {
                    info.percentage(String.valueOf(100));
                    break;
                }
                case FAILED: {
                    info.percentage(String.valueOf(100));
                    break;
                }
            }
            return info;
        }
        StatisticalManagerService service = (StatisticalManagerService)StatisticalManagerDSL.stateful().at(epr).build();
        return service.getComputationInfo(computationId);
    }

    @Override
    public SMOutput getAlgorithmOutputs(final String algorithm) {
        Call<ComputationFactoryStub, SMOutput> call = new Call<ComputationFactoryStub, SMOutput>(){

            public SMOutput call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.getAlgorithmOutputs(algorithm);
            }
        };
        try {
            return (SMOutput)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public SMParameters getAlgorithmParameters(final String algorithm) {
        Call<ComputationFactoryStub, SMParameters> call = new Call<ComputationFactoryStub, SMParameters>(){

            public SMParameters call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.getAlgorithmParameters(algorithm);
            }
        };
        try {
            return (SMParameters)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public SMComputations getComputations(final String user, final SMTypeParameter ... typeParameters) {
        Call<ComputationFactoryStub, SMComputations> call = new Call<ComputationFactoryStub, SMComputations>(){

            public SMComputations call(ComputationFactoryStub endpoint) throws Exception {
                SMComputationsRequest request = new SMComputationsRequest();
                request.user(user);
                request.page(15);
                request.parameters(Arrays.asList(typeParameters));
                return endpoint.getComputations(request);
            }
        };
        try {
            return (SMComputations)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String executeComputation(final SMComputationRequest requestComputation) {
        Call<ComputationFactoryStub, String> call = new Call<ComputationFactoryStub, String>(){

            public String call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.executeComputation(requestComputation);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public SMComputation getComputation(final String computationId) {
        Call<ComputationFactoryStub, SMComputation> call = new Call<ComputationFactoryStub, SMComputation>(){

            public SMComputation call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.getComputation(computationId);
            }
        };
        try {
            return (SMComputation)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public void removeComputation(final String computationId) {
        W3CEndpointReference epr = this.getEPRComputationResourceFW(computationId);
        if (epr == null) {
            Call<ComputationFactoryStub, JAXWSUtils.Empty> call = new Call<ComputationFactoryStub, JAXWSUtils.Empty>(){

                public JAXWSUtils.Empty call(ComputationFactoryStub endpoint) throws Exception {
                    endpoint.removeComputation(computationId);
                    return new JAXWSUtils.Empty();
                }
            };
            try {
                this.delegate.make((Call)call);
                return;
            }
            catch (Exception e) {
                throw FaultDSL.again((Throwable)e).asServiceException();
            }
        }
        StatisticalManagerService service = (StatisticalManagerService)StatisticalManagerDSL.stateful().at(epr).build();
        service.removeComputation(computationId);
    }

    @Override
    public SMListGroupedAlgorithms getAlgorithmsUser(SMTypeParameter ... typeParameters) {
        SMTypeParameter[] list = typeParameters;
        final SMAlgorithmsRequest request = new SMAlgorithmsRequest(Arrays.asList(list));
        Call<ComputationFactoryStub, SMListGroupedAlgorithms> call = new Call<ComputationFactoryStub, SMListGroupedAlgorithms>(){

            public SMListGroupedAlgorithms call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.getAlgorithmsUser(request);
            }
        };
        try {
            return (SMListGroupedAlgorithms)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String resubmitComputation(final String computationId) {
        Call<ComputationFactoryStub, String> call = new Call<ComputationFactoryStub, String>(){

            public String call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.resubmitComputation(computationId);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

