package org.gcube.data.analysis.statisticalmanager.experimentspace;


import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;
import java.util.Set;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;

import org.gcube.data.access.queueManager.FactoryConfiguration;
import org.gcube.data.access.queueManager.QueueItemHandler;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueConsumerFactory;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationResource;
import org.gcube.data.analysis.statisticalmanager.persistence.RuntimeResourceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;


/**
 * @author gioia
 *
 */
public class ComputationFactoryResource extends GCUBEWSResource {
	
	static GCUBELog logger = new GCUBELog(ComputationFactoryResource.class);
	
	private static final String SERVICE = "STATISTICAL_MANAGER";
	
	private static final float RESOURCES_RATE_DISTRIBUTIONS 	=  0.8f;
	private static final float RESOURCES_RATE_EVALUATORS 		=  0.1f;
	private static final int RESOURCES_CONSTANT_MODELS 			=  1;
	
	private static int D4SCIENCE_COMPUTATIONS = 0;
	
	
//	private static String URL_BROKER = "tcp://ui.grid.research-infrastructures.eu:6166";
//	private static final String URL_BROKER = "vm://localhost";
	
	
	public static final String MESSAGE_COMPUTATION_ID 	= "computationId";
	public static final String MESSAGE_SCOPE 			= "scope";
	public static final String MESSAGE_REQUEST 			= "request";
	public static final String QUEUE 					= "GHN";
	
	public static FactoryConfiguration queueConfig;	
	private static HashMap<String,Integer> busyLocalResources;
	
	
	@Override
	protected void initialise(Object... arg0) throws Exception {
		
		// Initialize local resource;
		busyLocalResources = new HashMap<String,Integer>();
		
		// Initialize statistical manager service queue
		String infra = (String)GHNContext.getContext().getProperty(GHNContext.INFRASTRUCTURE_NAME, true);
		Set<EndpointReferenceType> set =  GCUBEScope.getScope("/"+infra).getServiceMap().getEndpoints(GHNContext.MSGBROKER);
		String url_broker = ((EndpointReferenceType)set.toArray()[0]).getAddress().toString();
		
		queueConfig =  new FactoryConfiguration(infra,
				SERVICE, url_broker, null, null);
		queueConfig.setInitialRedeliveryDelay(3000);
		queueConfig.setMaximumRedeliveries(-1);
		queueConfig.setUseExponentialRedelivery(false);
		
		// Initialize jdbc and hibernate DB
		RuntimeResourceManager.initializeDataBase();
		
		
		QueueConsumerFactory consumerFactory = QueueConsumerFactory.get(queueConfig);
		QueueItemHandler<RequestItem> handler = new QueueItemHandler<RequestItem>() {

			@Override
			public void handleQueueItem(RequestItem item) throws Exception {
				
				logger.debug("Message received" + item.getId());
				
				SMComputationRequest request = (SMComputationRequest)item.getParameters().
				get(MESSAGE_REQUEST);
		
				long computationId = (Long)item.getParameters().get(MESSAGE_COMPUTATION_ID);
				logger.debug("ComputationId " + computationId);
				GCUBEStatefulPortTypeContext stfctx = ComputationContext.getContext();
				logger.debug("User" + request.getUser());
				GCUBEWSResourceKey key = stfctx.makeKey(request.getUser());               
				logger.debug("Scope " + (String)item.getParameters().get(MESSAGE_SCOPE));
				
				String scope = (String)item.getParameters().get(MESSAGE_SCOPE);
				
				ComputationContext.getContext().getServiceContext().
				setScope(Thread.currentThread(), GCUBEScope.getScope(scope));
				
				ComputationResource wsResource = (ComputationResource) ComputationContext.
				getContext().getWSHome().create(key,request.getUser(),scope);
				
				logger.debug("Resource created");
				wsResource.executeComputation(request.getConfig(), computationId); 
				
			}

			@Override
			public void close() {
				
			}
		};
		
		consumerFactory.register(QUEUE, QueueType.REQUEST, handler);
		
	}
	

	
	private int getLocalResourcesNeeded(SMAlgorithm algorithm) {
			
		int resources = 0;
		if (algorithm.getCategory().equals(ComputationalAgentClass.DISTRIBUTIONS.toString())) {
			resources = (int) Math.ceil(getLocalResourcesFree() * RESOURCES_RATE_DISTRIBUTIONS);
		} else if(algorithm.getCategory().equals(ComputationalAgentClass.EVALUATORS.toString())) {
			resources = (int) Math.ceil(getLocalResourcesFree() * RESOURCES_RATE_EVALUATORS);
		} else {
			resources = RESOURCES_CONSTANT_MODELS;
		}	
		return resources;
	}
		
	private int allLocalResources() {
		return Runtime.getRuntime().availableProcessors();
	}
	
	private int localResourcesBusy() {
		
		int result = 0;
		for (Entry<String, Integer> entry : busyLocalResources.entrySet()) {
			result+= entry.getValue();
		}
		return result;
	}
	
	public synchronized int setLocalResourcesAvailable(String agentId,
			SMAlgorithm algorithm) {
			
		int resourcesNeeded = getLocalResourcesNeeded(algorithm);
		int resourcesBusy = localResourcesBusy();
		int resourcesFree = allLocalResources() - resourcesBusy;
		
		logger.debug("---------> Resources needed :" + resourcesNeeded);
		logger.debug("---------> Resources busy   :" + resourcesBusy);
		
		if ((resourcesNeeded == 0) || (resourcesFree < resourcesNeeded))
			return 0;
		
		busyLocalResources.put(agentId, resourcesNeeded);
	
		return resourcesNeeded;	
	}
	
	public synchronized void cleanLocalResourcesComputational(String genId) {
		
		logger.debug(" ---------- Resources clean up called ----" + busyLocalResources);	
		busyLocalResources.remove(genId);
		logger.debug(" ---------- Resources busy " + busyLocalResources);
	}
	
	public synchronized int getLocalResourcesFree() {
		return allLocalResources() - localResourcesBusy();
	}
	
	public static String getConfigPath() {
    	return ServiceContext.getContext().getProperty("configDir") + "/cfg/";
	}
	
    public List<StatisticalType> getListParameters(String category, String algorithmName) throws Exception {
	   	
    	switch(AlgorithmCategory.valueOf(category)){
    	case DISTRIBUTIONS:
    		return GeneratorsFactory.getAlgorithmParameters(getConfigPath(), 
    				algorithmName);

    	case EVALUATORS:
    		return EvaluatorsFactory.getEvaluatorParameters(getConfigPath(), 
    				algorithmName);

    	case MODELS:
    		return ModelersFactory.getModelParameters(getConfigPath(),
    				algorithmName);
    	
    	case TRANSDUCERS:
    		return TransducerersFactory.getTransducerParameters(getConfigPath(),
    				algorithmName);
    		
    	case CLUSTERERS:
    		return ClusterersFactory.getClustererParameters(getConfigPath(),
    				algorithmName);

    	default:
    		throw new Exception();
    	}

    }
    
    public String getAgorithmDescription(String category, String algorithmName) throws Exception {
	   	
    	switch(AlgorithmCategory.valueOf(category)){
    	case DISTRIBUTIONS:
    		return GeneratorsFactory.getDescription(getConfigPath(), algorithmName);

    	case EVALUATORS:
    		return EvaluatorsFactory.getDescription(getConfigPath(), 
    				algorithmName);

    	case MODELS:
    		return ModelersFactory.getDescription(getConfigPath(),
    				algorithmName);
    	
    	case TRANSDUCERS:
    		return TransducerersFactory.getDescription(getConfigPath(),
    				algorithmName);
    		
    	case CLUSTERERS:
    		return ClusterersFactory.getDescription(getConfigPath(),
    				algorithmName);

    	default:
    		throw new Exception();
    	}

    }
    
	public synchronized boolean setD4ScienceComputation() {
		if (D4SCIENCE_COMPUTATIONS < 2) {
			D4SCIENCE_COMPUTATIONS++;
			return true;
		} 
		return false;
	}
	
	public synchronized void cleanD4ScienceComputation() {
		D4SCIENCE_COMPUTATIONS--;
	}
}
