/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.access.queueManager.FactoryConfiguration;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueProducer;
import org.gcube.data.access.queueManager.impl.QueueProducerFactory;
import org.gcube.data.access.queueManager.model.QueueItem;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationFactoryPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithmsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public class ComputationFactory
extends GCUBEPortType
implements ComputationFactoryPortType {
    GCUBELog logger = new GCUBELog(ComputationFactory.class);
    private static final String keyFRString = "keyFactoryResource";
    private static ComputationFactoryResource resource;

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public static ComputationFactoryResource getFactoryResource() {
        return resource;
    }

    protected void onInitialisation() throws Exception {
        if (resource != null) {
            return;
        }
        this.logger.info((Object)"Initialising the factory state...");
        new Thread(){

            @Override
            public void run() {
                int attempts = 0;
                boolean created = false;
                while (attempts++ < 10) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ComputationFactory.this.logger.error((Object)"Failed to sleep in between factory creation");
                        ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                        break;
                    }
                    try {
                        for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                            ServiceContext.getContext().setScope(scope);
                        }
                        resource = (ComputationFactoryResource)ComputationFactoryContext.getContext().getWSHome().create(ComputationFactoryContext.getContext().makeKey(ComputationFactory.keyFRString), new Object[0]);
                        created = true;
                        break;
                    }
                    catch (Exception e) {
                        ComputationFactory.this.logger.error((Object)"Failed to create the resource", (Throwable)e);
                    }
                }
                if (!created) {
                    ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                }
            }
        }.start();
    }

    public SMParameters getAlgorithmParameters(SMAlgorithm request) throws RemoteException, GCUBEFault {
        List<StatisticalType> parameters = null;
        try {
            parameters = ComputationFactory.getFactoryResource().getListParameters(request.getCategory(), request.getName());
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException("Parameters unknown for this computation", e).toFault(new String[0]);
        }
        this.logger.debug((Object)"------------- parameters retrieved");
        ArrayList<SMParameter> listParameters = new ArrayList<SMParameter>();
        for (StatisticalType param : parameters) {
            SMParameter smParameter = FactoryComputationParameter.createParameter(param);
            if (smParameter == null) continue;
            listParameters.add(smParameter);
        }
        return new SMParameters(listParameters.toArray(new SMParameter[listParameters.size()]));
    }

    public SMListGroupedAlgorithms getAlgorithms(SMAlgorithmsRequest request) throws RemoteException, GCUBEFault {
        try {
            return ServiceUtil.getGroupedAlgorithm(request.getParameters());
        }
        catch (Exception e) {
            this.logger.error((Object)"Get features error ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public SMComputations getComputations(SMComputationsRequest request) throws RemoteException, GCUBEFault {
        this.logger.trace((Object)("List computations request by user " + request.getUser()));
        try {
            if (request.getParameters() == null) {
                SMComputations computations = SMPersistenceManager.getComputations(request.getUser(), null, null);
                return computations;
            }
            ArrayList<SMComputation> computationsList = new ArrayList<SMComputation>();
            for (SMGroupedAlgorithms groupedAlgorithm : ServiceUtil.getGroupedAlgorithm(request.getParameters()).getList()) {
                for (SMAlgorithm algorithm : groupedAlgorithm.getList()) {
                    SMComputations computations = SMPersistenceManager.getComputations(request.getUser(), algorithm.getName(), algorithm.getCategory());
                    computationsList.addAll(Arrays.asList(computations.getList()));
                }
            }
            return new SMComputations(computationsList.toArray(new SMComputation[computationsList.size()]));
        }
        catch (Exception e) {
            this.logger.error((Object)"Get Computations error ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public String executeComputation(SMComputationRequest requestComputation) throws RemoteException, GCUBEFault {
        this.logger.debug((Object)"Send a new user request");
        try {
            QueueProducerFactory factory = QueueProducerFactory.get((FactoryConfiguration)ComputationFactoryResource.queueConfig);
            QueueProducer producer = factory.getSubmitter("GHN", QueueType.REQUEST);
            long computationId = SMPersistenceManager.addComputation(requestComputation);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("request", requestComputation);
            parameters.put("computationId", computationId);
            parameters.put("scope", ServiceContext.getContext().getScope().toString());
            producer.send((QueueItem)new RequestItem("CallScript", null, parameters));
            return String.valueOf(computationId);
        }
        catch (Exception e) {
            this.logger.error((Object)"Message sent with exception ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMComputation getComputation(String computationId) throws RemoteException, GCUBEFault {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select computation from SMComputation computation where computation.operationId = :name");
            query.setParameter("name", (Object)Long.valueOf(computationId));
            List objects = query.list();
            SMComputation computation = (SMComputation)objects.get(0);
            Query queryParameters = session.createQuery("select parameter from SMEntry parameter where parameter.computationId = :operationId");
            queryParameters.setParameter("operationId", (Object)computation.getOperationId());
            List parameters = queryParameters.list();
            computation.setParameters(parameters.toArray(new SMEntry[parameters.size()]));
            SMComputation sMComputation = (SMComputation)objects.get(0);
            return sMComputation;
        }
        finally {
            session.close();
        }
    }

    public VOID removeComputation(String computationId) throws RemoteException, GCUBEFault {
        this.logger.debug((Object)"Remove computation from factory");
        SMPersistenceManager.removeOperation(Long.parseLong(computationId));
        return new VOID();
    }
}

