/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;

public class HibernateManager {
    private static GCUBELog logger = new GCUBELog(HibernateManager.class);
    private static final String DRIVER_CLASS = "hibernate.connection.driver_class";
    private static final String URL = "hibernate.connection.url";
    private static final String USERNAME = "hibernate.connection.username";
    private static final String PASSWORD = "hibernate.connection.password";
    private static SessionFactory sessionFactory;

    public static void buildSessionFactory(String url, String userName, String password) {
        try {
            Configuration configuration = new Configuration().configure(HibernateManager.class.getResource("hibernate.cfg.xml"));
            configuration.setProperty(DRIVER_CLASS, "org.postgresql.Driver");
            configuration.setProperty(URL, url);
            configuration.setProperty(USERNAME, userName);
            configuration.setProperty(PASSWORD, password);
            sessionFactory = configuration.buildSessionFactory();
        }
        catch (Throwable ex) {
            logger.error((Object)("Initial SessionFactory creation failed." + ex));
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            logger.error((Object)"SessionFactory is not initialized");
        }
        return sessionFactory;
    }

    public static void closeSession(Session session) {
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void roolbackTransaction(Transaction t) {
        try {
            if (t != null) {
                t.rollback();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

