package org.gcube.data.analysis.statisticalmanager.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTypeParameter;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;

public class ServiceUtil {

	public static SMListGroupedAlgorithms getGroupedAlgorithm(SMTypeParameter[] param ) throws Exception {

		String configPath = ComputationFactoryResource.getConfigPath();
		ArrayList<SMGroupedAlgorithms> features = new ArrayList<SMGroupedAlgorithms>();
		HashMap<String,List<String>> mapFeatures = ProcessorsFactory.getAllFeatures(configPath);

		for (Entry<String,List<String>> entry : mapFeatures.entrySet()) {
			String category = entry.getKey();
			SMGroupedAlgorithms feature = new SMGroupedAlgorithms();
			feature.setCategory(ComputationalAgentClass.fromString(category));

			ArrayList<SMAlgorithm> algorithms = new ArrayList<SMAlgorithm>();
			for (String algorithmName : entry.getValue()){
				List<StatisticalType> parameters =  ComputationFactory.getFactoryResource().getListParameters(category, algorithmName);

				if (param == null || (param.length == 0)) {
					String description = ComputationFactory.getFactoryResource().getAgorithmDescription(category, algorithmName);
					algorithms.add(new SMAlgorithm(category, description, algorithmName));
				} else {

					for (SMTypeParameter typeParameter : param) {
						if (FactoryComputationParameter.containParameter(typeParameter, parameters)){

							String description = ComputationFactory.getFactoryResource().getAgorithmDescription(category, algorithmName);
							algorithms.add(new SMAlgorithm(category, description, algorithmName));
						}
					}
				}
			}

			if (!algorithms.isEmpty()) {
				feature.setList(algorithms.toArray(new SMAlgorithm[algorithms.size()]));
				features.add(feature);
			}
		}

		return new SMListGroupedAlgorithms(features.toArray(new SMGroupedAlgorithms[features.size()]));

	}

}
