/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace;

import javax.jms.JMSException;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.access.queueManager.QueueItemHandler;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueConsumerFactory;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationResource;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;

public class ServiceQueueConsumer
implements QueueItemHandler<RequestItem> {
    private static GCUBELog logger = new GCUBELog(ServiceQueueConsumer.class);
    private QueueConsumerFactory consumerFactory;

    public ServiceQueueConsumer(QueueConsumerFactory consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public void handleQueueItem(RequestItem item) throws Exception {
        logger.debug((Object)("Message received" + item.getId()));
        SMComputationRequest request = (SMComputationRequest)item.getParameters().get("request");
        long computationId = (Long)item.getParameters().get("computationId");
        logger.debug((Object)("ComputationId " + computationId));
        GCUBEStatefulPortTypeContext stfctx = ComputationContext.getContext();
        logger.debug((Object)("User" + request.getUser()));
        GCUBEWSResourceKey key = stfctx.makeKey(request.getUser());
        String scope = (String)item.getParameters().get("scope");
        logger.debug((Object)("Scope " + scope));
        ComputationContext.getContext().getServiceContext().setScope(Thread.currentThread(), GCUBEScope.getScope((String)scope));
        ComputationResource wsResource = (ComputationResource)ComputationContext.getContext().getWSHome().create(key, new Object[]{request.getUser(), scope});
        logger.debug((Object)"Resource created");
        wsResource.executeComputation(request.getConfig(), computationId);
    }

    public void close() {
    }

    private void retryToConnect() {
        try {
            this.consumerFactory.close();
            this.consumerFactory.register("STATISTICAL_MANAGER", QueueType.REQUEST, (QueueItemHandler)this);
        }
        catch (JMSException e) {
            logger.error((Object)"Consumer connection exception ....retry to connect", (Throwable)e);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {
                logger.error((Object)"Consumer wait time to connect error", (Throwable)e);
            }
            this.retryToConnect();
        }
    }

    public void onException(JMSException arg0) {
        logger.debug((Object)"Consumer connection exception ....retry to connect", (Throwable)arg0);
        this.retryToConnect();
    }
}

