/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.access.queueManager.FactoryConfiguration;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueProducer;
import org.gcube.data.access.queueManager.impl.QueueProducerFactory;
import org.gcube.data.access.queueManager.model.QueueItem;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationFactoryPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithmsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationConfig;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntries;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMInputEntry;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public class ComputationFactory
extends GCUBEPortType
implements ComputationFactoryPortType {
    GCUBELog logger = new GCUBELog(ComputationFactory.class);
    private static final String keyFRString = "keyFactoryResource";
    private static ComputationFactoryResource resource;

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public static ComputationFactoryResource getFactoryResource() {
        return resource;
    }

    protected void onInitialisation() throws Exception {
        if (resource != null) {
            return;
        }
        this.logger.info((Object)"Initialising the factory state...");
        new Thread(){

            @Override
            public void run() {
                int attempts = 0;
                boolean created = false;
                while (attempts++ < 10) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ComputationFactory.this.logger.error((Object)"Failed to sleep in between factory creation");
                        ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                        break;
                    }
                    try {
                        for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                            ComputationFactory.this.logger.info((Object)("Creating the resource within the scope " + scope.getName()));
                            ServiceContext.getContext().setScope(scope);
                        }
                        resource = (ComputationFactoryResource)ComputationFactoryContext.getContext().getWSHome().create(ComputationFactoryContext.getContext().makeKey(ComputationFactory.keyFRString), new Object[0]);
                        created = true;
                        break;
                    }
                    catch (Exception e) {
                        ComputationFactory.this.logger.error((Object)"Failed to create the resource", (Throwable)e);
                    }
                }
                if (!created) {
                    ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                }
            }
        }.start();
    }

    public SMParameters getAlgorithmParameters(String algorithm) throws RemoteException, GCUBEFault {
        List<StatisticalType> parameters = null;
        try {
            parameters = ComputationFactory.getFactoryResource().getListParameters(ServiceUtil.getAlgorithmCategory(algorithm), algorithm);
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException("Parameters unknown for this computation", e).toFault(new String[0]);
        }
        this.logger.debug((Object)"------------- parameters retrieved");
        ArrayList<SMParameter> listParameters = new ArrayList<SMParameter>();
        for (StatisticalType param : parameters) {
            SMParameter smParameter = FactoryComputationParameter.createParameter(param);
            if (smParameter == null) continue;
            listParameters.add(smParameter);
        }
        return new SMParameters(listParameters.toArray(new SMParameter[listParameters.size()]));
    }

    public SMListGroupedAlgorithms getAlgorithmsUser(SMAlgorithmsRequest request) throws RemoteException, GCUBEFault {
        this.logger.debug((Object)"Called get user perspective");
        try {
            String configPath = ComputationFactoryResource.getConfigPath();
            HashMap map = ProcessorsFactory.getAllFeaturesUser((String)configPath);
            return ServiceUtil.getGroupedAlgorithm(request.getParameters(), map);
        }
        catch (Exception e) {
            this.logger.error((Object)"Get features error ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public SMListGroupedAlgorithms getAlgorithms(SMAlgorithmsRequest request) throws RemoteException, GCUBEFault {
        this.logger.debug((Object)"Called get all algorithm");
        try {
            String configPath = ComputationFactoryResource.getConfigPath();
            HashMap map = ProcessorsFactory.getAllFeatures((String)configPath);
            return ServiceUtil.getGroupedAlgorithm(request.getParameters(), map);
        }
        catch (Exception e) {
            this.logger.error((Object)"Get features error ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public SMComputations getComputations(SMComputationsRequest request) throws RemoteException, GCUBEFault {
        this.logger.trace((Object)("List computations request by user " + request.getUser()));
        try {
            if (request.getParameters() == null) {
                SMComputations computations = SMPersistenceManager.getComputations(request.getUser(), null, null);
                return computations;
            }
            ArrayList<SMComputation> computationsList = new ArrayList<SMComputation>();
            String configPath = ComputationFactoryResource.getConfigPath();
            HashMap map = ProcessorsFactory.getAllFeatures((String)configPath);
            SMGroupedAlgorithms[] sMGroupedAlgorithmsArray = ServiceUtil.getGroupedAlgorithm(request.getParameters(), map).getList();
            int n = sMGroupedAlgorithmsArray.length;
            int n2 = 0;
            while (n2 < n) {
                SMGroupedAlgorithms groupedAlgorithm = sMGroupedAlgorithmsArray[n2];
                SMAlgorithm[] sMAlgorithmArray = groupedAlgorithm.getList();
                int n3 = sMAlgorithmArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    SMAlgorithm algorithm = sMAlgorithmArray[n4];
                    SMComputations computations = SMPersistenceManager.getComputations(request.getUser(), algorithm.getName(), algorithm.getCategory());
                    computationsList.addAll(Arrays.asList(computations.getList()));
                    ++n4;
                }
                ++n2;
            }
            return new SMComputations(computationsList.toArray(new SMComputation[computationsList.size()]));
        }
        catch (Exception e) {
            this.logger.error((Object)"Get Computations error ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public String executeComputation(SMComputationRequest requestComputation) throws RemoteException, GCUBEFault {
        GCUBEScope scope = ServiceContext.getContext().getScope();
        if (scope.isInfrastructure()) {
            throw ServiceContext.getContext().getDefaultException(new StatisticalManagerException()).toFault(new String[0]);
        }
        return this.executeComputation(requestComputation, scope, null);
    }

    private String executeComputation(SMComputationRequest requestComputation, GCUBEScope scope, String computationId) throws GCUBEFault {
        this.logger.debug((Object)"Send a new user request");
        try {
            String queue = scope.getName();
            if (scope.getType() == GCUBEScope.Type.VRE) {
                queue = scope.getEnclosingScope().getName();
            }
            this.logger.debug((Object)("GET queue " + queue));
            QueueProducerFactory factory = QueueProducerFactory.get((FactoryConfiguration)ComputationFactoryResource.createQueueConfig(queue));
            QueueProducer producer = factory.getSubmitter("STATISTICAL_MANAGER", QueueType.REQUEST);
            String category = ServiceUtil.getAlgorithmCategory(requestComputation.getConfig().getAlgorithm());
            if (computationId == null) {
                long id = SMPersistenceManager.addComputation(requestComputation, category);
                computationId = String.valueOf(id);
            } else {
                SMPersistenceManager.setOperationStatus(Long.parseLong(computationId), SMOperationStatus.PENDING);
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("request", requestComputation);
            parameters.put("computationId", computationId);
            parameters.put("scope", ServiceContext.getContext().getScope().toString());
            producer.send((QueueItem)new RequestItem("CallScript", null, parameters));
            return String.valueOf(computationId);
        }
        catch (Exception e) {
            this.logger.error((Object)"Message sent with exception ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public SMComputation getComputation(String computationId) throws RemoteException, GCUBEFault {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select computation from SMComputation computation where computation.operationId = :name");
            query.setParameter("name", (Object)Long.valueOf(computationId));
            List objects = query.list();
            SMComputation computation = (SMComputation)objects.get(0);
            Query queryParameters = session.createQuery("select parameter from SMEntry parameter where parameter.computationId = :operationId");
            queryParameters.setParameter("operationId", (Object)computation.getOperationId());
            List parameters = queryParameters.list();
            computation.setParameters(parameters.toArray(new SMEntry[parameters.size()]));
            SMComputation sMComputation = (SMComputation)objects.get(0);
            return sMComputation;
        }
        finally {
            session.close();
        }
    }

    public VOID removeComputation(String computationId) throws RemoteException, GCUBEFault {
        this.logger.debug((Object)"Remove computation from factory");
        SMPersistenceManager.removeComputation(Long.parseLong(computationId));
        return new VOID();
    }

    public String resubmitComputation(String computationId) throws RemoteException, GCUBEFault {
        GCUBEScope scope = ServiceContext.getContext().getScope();
        if (scope.isInfrastructure()) {
            throw ServiceContext.getContext().getDefaultException(new StatisticalManagerException()).toFault(new String[0]);
        }
        try {
            SMComputation computation = (SMComputation)SMPersistenceManager.getOperation(Long.parseLong(computationId));
            ArrayList parameters = new ArrayList();
            Session session = HibernateManager.getSessionFactory().openSession();
            try {
                Query queryParameters = session.createQuery("select parameter from SMEntry parameter where parameter.computationId = :computationId");
                queryParameters.setParameter("computationId", (Object)computation.getOperationId());
                parameters.addAll(queryParameters.list());
            }
            finally {
                HibernateManager.closeSession((org.hibernate.Session)session);
            }
            ArrayList<SMInputEntry> entries = new ArrayList<SMInputEntry>();
            for (SMEntry parameter : parameters) {
                entries.add(new SMInputEntry(parameter.getKey(), parameter.getValue()));
            }
            SMEntries inputEntries = new SMEntries(entries.toArray(new SMInputEntry[entries.size()]));
            SMComputationConfig computationConfig = new SMComputationConfig(computation.getAlgorithm(), inputEntries);
            SMComputationRequest request = new SMComputationRequest(computationConfig, null, null, computation.getPortalLogin());
            this.executeComputation(request, scope, computationId);
            return computationId;
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }
}

