/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;

public abstract class CSVAbstractLineProcessor
implements CSVLineProcessor {
    private static final String FIELD = "field";
    private boolean stopFieldName = false;
    protected List<String> colNames = new ArrayList<String>();
    protected List<String> sqlTypes = new ArrayList<String>();
    protected String separator;
    private boolean quote = false;

    public CSVAbstractLineProcessor(String separator) {
        this.separator = separator;
    }

    public void processDataLine(int arg0, List<String> fieldValues) {
        if (!this.colNames.isEmpty() || this.stopFieldName) {
            return;
        }
        for (int i = 0; i < fieldValues.size(); ++i) {
            String fieldValue = fieldValues.get(i);
            String[] values = fieldValue.split(this.separator);
            int j = 0;
            if (!this.separator.equals(",")) {
                for (String value : values) {
                    if (!this.quote) {
                        this.colNames.add(FIELD + (j + i));
                        ++j;
                    }
                    if (!value.startsWith("\"") && !value.startsWith("'")) continue;
                    this.quote = !this.quote;
                }
                continue;
            }
            this.colNames.add(FIELD + i);
        }
        this.stopFieldName = true;
    }

    public void processHeaderLine(int arg0, List<String> fieldNames) {
        for (String fieldName : fieldNames) {
            String[] values;
            for (String value : values = fieldName.split(this.separator)) {
                this.colNames.add(value);
            }
        }
    }

    public List<String> getColsName() {
        return this.colNames;
    }

    public List<String> getSqlType() {
        return this.sqlTypes;
    }
}

