/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace.computation;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.data.analysis.statisticalmanager.SMOperationType;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.persistence.RemoteStorage;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable;

public class BuilderComputationOutput {
    private static GCUBELog logger = new GCUBELog(BuilderComputationOutput.class);
    private String portalLogin;
    private String scope;
    private SMComputation computation;

    public BuilderComputationOutput(String portalLogin, String scope, SMComputation computation) {
        this.portalLogin = portalLogin;
        this.scope = scope;
        this.computation = computation;
    }

    private SMTable serializeTabular(OutputTable output) throws Exception {
        String template = ((TableTemplates)output.getTemplateNames().get(0)).toString();
        SMTable table = new SMTable(template);
        table.setPortalLogin(this.portalLogin);
        table.setAlgorithm(this.computation.getAlgorithm());
        table.setResourceType(SMResourceType.TABULAR.ordinal());
        table.setResourceId(output.getTableName());
        table.setDescription(output.getDescription());
        table.setName(output.getName());
        table.setProvenance(SMOperationType.COMPUTED.ordinal());
        table.setCreationDate(Calendar.getInstance());
        table.setOperationId(this.computation.getOperationId());
        SMPersistenceManager.addCreatedResource((SMResource)table);
        return table;
    }

    private SMFile serializeFile(PrimitiveType output) throws Exception {
        File outputFile = (File)output.getContent();
        RemoteStorage storage = new RemoteStorage(this.portalLogin, this.scope);
        String fileName = UUID.randomUUID().toString();
        String url = storage.putFile(outputFile, fileName);
        SMFile file = new SMFile("mimeType", fileName, url);
        file.setPortalLogin(this.portalLogin);
        file.setAlgorithm(this.computation.getAlgorithm());
        file.setResourceType(SMResourceType.FILE.ordinal());
        file.setResourceId(UUID.randomUUID().toString());
        file.setDescription(output.getDescription());
        file.setName(outputFile.getName());
        file.setProvenance(SMOperationType.COMPUTED.ordinal());
        file.setCreationDate(Calendar.getInstance());
        file.setOperationId(this.computation.getOperationId());
        SMPersistenceManager.addCreatedResource((SMResource)file);
        return file;
    }

    private SMObject serializePrimitiveObject(PrimitiveType primitiveObject) {
        switch (primitiveObject.getType()) {
            case STRING: {
                SMObject object = new SMObject((String)primitiveObject.getContent());
                object.setPortalLogin(this.portalLogin);
                object.setAlgorithm(this.computation.getAlgorithm());
                object.setName(PrimitiveTypes.STRING.toString());
                object.setResourceType(SMResourceType.OBJECT.ordinal());
                object.setDescription(primitiveObject.getDescription());
                object.setProvenance(SMOperationType.COMPUTED.ordinal());
                object.setCreationDate(Calendar.getInstance());
                object.setOperationId(this.computation.getOperationId());
                return object;
            }
        }
        return null;
    }

    private SMObject serializeImage(PrimitiveType primitiveObject) throws Exception {
        RemoteStorage storage = new RemoteStorage(this.portalLogin, this.scope);
        Map map = (Map)primitiveObject.getContent();
        String dirName = File.separator + UUID.randomUUID().toString();
        for (Map.Entry entry : map.entrySet()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)ImageTools.toBufferedImage((Image)((Image)entry.getValue())), "png", os);
            storage.putStream(new ByteArrayInputStream(os.toByteArray()), dirName + File.separator + (String)entry.getKey());
        }
        SMObject resource = new SMObject(dirName);
        resource.setPortalLogin(this.portalLogin);
        resource.setResourceType(SMResourceType.OBJECT.ordinal());
        resource.setResourceId(UUID.randomUUID().toString());
        resource.setName(PrimitiveTypes.IMAGES.toString());
        resource.setDescription(primitiveObject.getDescription());
        resource.setProvenance(SMOperationType.COMPUTED.ordinal());
        resource.setCreationDate(Calendar.getInstance());
        resource.setOperationId(this.computation.getOperationId());
        return resource;
    }

    private SMObject serializeMap(PrimitiveType primitiveObject) throws Exception {
        SMResource resource;
        Map map = (Map)primitiveObject.getContent();
        LinkedHashMap outputs = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            resource = this.serialize((StatisticalType)entry.getValue());
            outputs.put(entry.getKey(), resource);
        }
        RemoteStorage storage = new RemoteStorage(this.portalLogin, this.scope);
        String url = storage.putObject(outputs);
        resource = new SMObject(url);
        resource.setPortalLogin(this.portalLogin);
        resource.setResourceType(SMResourceType.OBJECT.ordinal());
        resource.setResourceId(UUID.randomUUID().toString());
        resource.setName(PrimitiveTypes.MAP.toString());
        resource.setDescription(primitiveObject.getDescription());
        resource.setProvenance(SMOperationType.COMPUTED.ordinal());
        resource.setCreationDate(Calendar.getInstance());
        resource.setOperationId(this.computation.getOperationId());
        return resource;
    }

    public SMResource serialize(StatisticalType object) throws Exception {
        if (object instanceof OutputTable) {
            return this.serializeTabular((OutputTable)object);
        }
        if (object instanceof PrimitiveType) {
            PrimitiveType primitiveObject = (PrimitiveType)object;
            if (primitiveObject.getType() == PrimitiveTypes.MAP) {
                return this.serializeMap(primitiveObject);
            }
            if (primitiveObject.getType() == PrimitiveTypes.IMAGES) {
                return this.serializeImage(primitiveObject);
            }
            if (primitiveObject.getType() == PrimitiveTypes.FILE) {
                return this.serializeFile(primitiveObject);
            }
            return this.serializePrimitiveObject(primitiveObject);
        }
        throw new Exception();
    }
}

