package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;


public class CSVLineProcessorGeneric extends CSVAbstractLineProcessor {
	private static GCUBELog logger = new GCUBELog(CSVLineProcessorGeneric.class);
	private boolean stop = true;
	private int count = 0;
	private Map<String, List<String>> map;
	int maxIteration = 100;
	
	ArrayList<String> types;
	public ArrayList<ArrayList<String>> firstColumns = new ArrayList<ArrayList<String>>();

	public CSVLineProcessorGeneric(String separator) {
		super(separator);
	}

	@Override
	public boolean continueProcessing() {
		// if (firstColumns.size() != 0)
		// maxIteration = firstColumns.get(0).size() - 1;
		return stop;
	}

	// @Override //GIANPAOLO VERSION
	// public void processDataLine(int arg0, List<String> fields) {
	// super.processDataLine(arg0, fields);
	// int nrows = fields.size();
	// int maxrows = Math.min(100,nrows);
	// ArrayList<ArrayList<String>> values = new ArrayList<ArrayList<String>>();
	//
	// for (int i=0;i<maxrows;i++) {
	//
	// String fieldValue = fields.get(i);
	// if (fieldValue == null){
	// fieldValue = "";
	// }
	//
	// String[] columnsvalues = fieldValue.split(separator);
	// int ncolumns = columnsvalues.length;
	// for (int j=0;j<ncolumns;j++){
	// String columnValue = columnsvalues[j];
	// if (values.size()<i+1)
	// values.set(i, new ArrayList<String>());
	//
	// values.get(i).add(columnValue);
	// }
	//
	// }
	//
	// for (ArrayList<String> valuecolumn:values){
	// String sqlType = getSqlType(valuecolumn);
	// sqlTypes.add(sqlType);
	// stop = false;
	// }
	//
	// }

	private ArrayList<String> getColumn(int index,
			ArrayList<ArrayList<String>> values) {
		logger.debug("Column " + index);
		ArrayList<String> column = new ArrayList<String>();
		for (ArrayList<String> ar : values)
			if (ar != null && index < ar.size()) {
				// logger.debug(ar.get(i));
				column.add(ar.get(index));
			}
		printArray(column);
		return column;
	}

	@Override
	public void processDataLine(int arg0, List<String> fields) {

		super.processDataLine(arg0, fields);
		// printArray(fields);
		if (count >= maxIteration) {
			stop = false;
		} else {

			if (fields != null) {
				ArrayList<String> ar = new ArrayList<String>(fields);
				printArray(ar);
				String fieldValue = ar.get(0);
				List<String> elements = null;

				
//					try {
//						elements = Transformations.parseCVSString(fieldValue,
//								separator);
//					} catch (Exception e) {
//						elements = new ArrayList<String>();
//					}
				if (separator.equals(",")) 
					elements= fields;
				else elements = Arrays.asList(fieldValue.split(separator));
				
				printArray(elements);
				int ncolumns = elements.size();
				// int ncolumns = fields.size();
				logger.debug("number of columns are" + ncolumns);
				for (int i = 0; i < ncolumns; i++) {
					logger.debug("i: " + i);
					String element = elements.get(i);
					// String element = fields.get(i);
					logger.debug("element :" + element);
					logger.debug("count " + count);

					if (i >= firstColumns.size()) {
						ArrayList<String> newer = new ArrayList<String>();
						newer.add(element);
						firstColumns.add(newer);

					} else {
						firstColumns.get(i).add(element);
						// firstColumns.get(i).set(count, element );
					}
					logger.debug("in the column " + i + "put element" + element);
				}

			}

			count++;
		}

	}

	// @Override
	// public void processDataLine(int arg0, List<String> fields) {
	// //super.processDataLine(arg0, fields);
	// ArrayList<ArrayList<String>> values = new ArrayList<ArrayList<String>>();
	// int index = 0;
	// for (final String fieldValue : fields) {
	// logger.debug("field value: " +fieldValue);
	// if (fieldValue != null) {
	// logger.debug("INDEX :"+index);
	// if (index < 30) {
	//
	// ArrayList<String> row = new ArrayList<String>(
	// Arrays.asList(fieldValue.split(separator)));
	// printArray(row);
	// values.add(row);
	//
	// } else
	// break;
	//
	// index++;
	// logger.debug("INDEX after increment :"+index);
	// }
	//
	// }
	//
	// int array_index = firstIndexNotNull(values);
	// logger.debug("Column not null" + array_index);
	//
	// int size = values.get(array_index).size();
	// logger.debug("size :" + size);
	// int i = 0;
	// while (i < size) {
	// String sqlType = getSqlType(getColumn(i, values));
	// logger.debug("INDEX2 :"+i);
	// if (sqlType == null) {
	// logger.debug("Types of " + i + " column is null");
	// sqlTypes.add("varchar");
	// } else {
	// sqlTypes.add(sqlType);
	// logger.debug("Types of " + i + " column is " + sqlType);
	// }
	// i++;
	// logger.debug("INDEX2 after increment :"+i);
	// // }
	// }
	//
	// }

	private void printArray(List<String> a) {
		for (String ar : a) {
			logger.debug(ar);
			logger.debug("****");
		}
	}

	private int firstIndexNotNull(ArrayList<ArrayList<String>> ars) {
		int i = 0;
		for (ArrayList<String> ar : ars) {
			if (ar != null)
				return i;
			i++;
		}
		return -1;

	}

	// @Override //ANTIONIO VERSION
	// public void processDataLine(int arg0, List<String> fields) {
	// super.processDataLine(arg0, fields);
	//
	// for ( final String fieldValue : fields ) {
	// if (fieldValue != null) {
	// for(String value : fieldValue.split(separator)) {
	//
	// String sqlType = getSqlType(value);
	//
	// sqlTypes.add(sqlType);
	// }
	//
	// } else {
	// sqlTypes.add("varchar");
	// }
	// }
	// stop = false;
	// }

	public static String getSqlType(ArrayList<String> values) {

		String className = DataTypeRecognizer.guessType(values);
		String sqlType = null;
		if (String.class.getName().equals(className)) {
			sqlType = "varchar";
		}
		if (Boolean.class.getName().equals(className)) {
			sqlType = "boolean";
		}

		if (BigDecimal.class.getName().equals(className)) {
			sqlType = "double precision";
		}
		return sqlType;
	}

	public static String getSqlType(String value) {
		ArrayList<String> values = new ArrayList<String>();
		values.add(value);

		String className = DataTypeRecognizer.guessType(values);
		logger.debug("class name for : " + value + " is " + className);
		String sqlType = "varchar";
		if (String.class.getName().equals(className)) {
			sqlType = "varchar";
		}
		if (Boolean.class.getName().equals(className)) {
			sqlType = "boolean";
		}

		if (BigDecimal.class.getName().equals(className)) {
			sqlType = "double precision";
		}
		return sqlType;
	}

	public void addSqlType(ArrayList<String> values) {
		if (values != null)
			sqlTypes.addAll(values);
	}

};
