/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class CSVAbstractLineProcessor
implements CSVLineProcessor {
    private static GCUBELog logger = new GCUBELog(CSVAbstractLineProcessor.class);
    private static final String FIELD = "field";
    private boolean stopFieldName = false;
    protected List<String> colNames = new ArrayList<String>();
    protected List<String> sqlTypes = new ArrayList<String>();
    protected String separator;
    private boolean quote = false;

    public CSVAbstractLineProcessor(String separator) {
        this.separator = separator;
    }

    protected String formattedString(String refactorStrings) {
        logger.debug((Object)"formattedString method");
        logger.debug((Object)("string in input" + refactorStrings));
        ArrayList<String> ar = new ArrayList<String>(Arrays.asList(refactorStrings.split("\"")));
        String result = new String();
        int i = 0;
        while (i < ar.size()) {
            if (i % 2 == 0) {
                result.concat(ar.get(i));
            } else {
                String tmp = ar.get(i).replace(this.separator, " ");
                result.concat(tmp);
            }
            ++i;
        }
        logger.debug((Object)("result" + result));
        return result;
    }

    public void processDataLine(int arg0, List<String> fieldValues) {
        if (this.separator.equals("|")) {
            this.separator = "\\|";
        }
        if (this.separator.equals(".")) {
            this.separator = "\\.";
        }
        if (!this.separator.equals(",")) {
            String support = new String();
            for (String s : fieldValues) {
                support = String.valueOf(support) + s;
            }
            logger.debug((Object)("Support" + support));
            fieldValues.clear();
            fieldValues.add(support);
            this.printArray(fieldValues);
        }
        if (!this.colNames.isEmpty() || this.stopFieldName) {
            return;
        }
        int i = 0;
        while (i < fieldValues.size()) {
            String fieldValue = fieldValues.get(i);
            logger.debug((Object)("fieldValue:" + fieldValue));
            String[] values = fieldValue.split(this.separator);
            int j = 0;
            if (!this.separator.equals(",")) {
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (!this.quote) {
                        logger.debug((Object)("Value:" + value));
                        this.colNames.add(FIELD + (j + i));
                        ++j;
                    }
                    if (value.startsWith("\"") || value.startsWith("'")) {
                        this.quote = !this.quote;
                    }
                    ++n2;
                }
            } else {
                this.colNames.add(FIELD + i);
            }
            ++i;
        }
        this.stopFieldName = true;
    }

    public void processHeaderLine(int arg0, List<String> fieldNames) {
        for (String fieldName : fieldNames) {
            String[] values;
            String[] stringArray = values = fieldName.split(this.separator);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.colNames.add(value);
                ++n2;
            }
        }
    }

    public List<String> getColsName() {
        return this.colNames;
    }

    public List<String> getSqlType() {
        return this.sqlTypes;
    }

    private void printArray(List<String> a) {
        for (String ar : a) {
            logger.debug((Object)ar);
            logger.debug((Object)"****");
        }
    }
}

