/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.access.queueManager.FactoryConfiguration;
import org.gcube.data.access.queueManager.QueueItemHandler;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueConsumerFactory;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.AlgorithmCategory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ServiceQueueConsumer;
import org.gcube.data.analysis.statisticalmanager.persistence.RuntimeResourceManager;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;

public class ComputationFactoryResource
extends GCUBEWSResource {
    static GCUBELog logger = new GCUBELog(ComputationFactoryResource.class);
    private static final float RESOURCES_RATE_DISTRIBUTIONS = 0.8f;
    private static final float RESOURCES_RATE_EVALUATORS = 0.1f;
    private static final int RESOURCES_CONSTANT_MODELS = 1;
    private static int D4SCIENCE_COMPUTATIONS = 0;
    private static int LOCAL_COMPUTATIONS = 0;
    public static final String SERVICE = "STATISTICAL_MANAGER";
    public static final String MESSAGE_COMPUTATION_ID = "computationId";
    public static final String MESSAGE_SCOPE = "scope";
    public static final String MESSAGE_REQUEST = "request";
    private static HashMap<String, Integer> busyLocalResources;
    private static HashMap<String, FactoryConfiguration> queues;
    private static GCUBEScope scopeInfra;

    protected void initialise(Object ... arg0) throws Exception {
        busyLocalResources = new HashMap();
        queues = new HashMap();
        GCUBEScope[] gCUBEScopeArray = ServiceContext.getContext().getStartScopes();
        int n = gCUBEScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GCUBEScope scope = gCUBEScopeArray[n2];
            if (scope.getType() == GCUBEScope.Type.VO) {
                logger.debug((Object)("Creating queue for VO" + scope.getName()));
                ComputationFactoryResource.createQueueConfig(scope.getName());
            } else {
                logger.debug((Object)("Not VO scope, not created queue" + scope.getName()));
            }
            ++n2;
        }
        RuntimeResourceManager.initializeDataBase();
    }

    public static FactoryConfiguration createQueueConfig(String scope) throws Exception {
        logger.debug((Object)("Queue config for scope " + scope));
        FactoryConfiguration factory = queues.get(scope);
        if (factory != null) {
            return factory;
        }
        String infra = (String)GHNContext.getContext().getProperty("infrastructure", new boolean[]{true});
        Set set = GCUBEScope.getScope((String)("/" + infra)).getServiceMap().getEndpoints((Object)"MessageBroker");
        String url_broker = ((EndpointReferenceType)set.toArray()[0]).getAddress().toString();
        logger.debug((Object)" -----------------------------------------------------");
        logger.debug((Object)("Creating queue with name:" + infra + "." + scope + "." + SERVICE));
        FactoryConfiguration queueConfig = new FactoryConfiguration(infra, scope, url_broker, null, null);
        queueConfig.setInitialRedeliveryDelay(5000L);
        queueConfig.setMaximumRedeliveries(-1);
        queueConfig.setUseExponentialRedelivery(false);
        queues.put(scope, queueConfig);
        QueueConsumerFactory consumerFactory = QueueConsumerFactory.get((FactoryConfiguration)queueConfig);
        ServiceQueueConsumer consumer = new ServiceQueueConsumer(consumerFactory);
        consumerFactory.register(SERVICE, QueueType.REQUEST, (QueueItemHandler)consumer);
        return queueConfig;
    }

    public int getLocalResourcesNeeded(String algorithm, String category) {
        int resources = 0;
        resources = category.equals(ComputationalAgentClass.DISTRIBUTIONS.toString()) ? (int)Math.ceil((float)this.getLocalResourcesFree() * 0.8f) : (category.equals(ComputationalAgentClass.EVALUATORS.toString()) ? (int)Math.ceil((float)this.getLocalResourcesFree() * 0.1f) : 1);
        return resources;
    }

    private int allLocalResources() {
        return Runtime.getRuntime().availableProcessors();
    }

    private int localResourcesBusy() {
        int result = 0;
        for (Map.Entry<String, Integer> entry : busyLocalResources.entrySet()) {
            result += entry.getValue().intValue();
        }
        return result;
    }

    public synchronized int setLocalResourcesAvailable(String agentId, String algorithm, String category) {
        int resourcesNeeded = this.getLocalResourcesNeeded(algorithm, category);
        int resourcesBusy = this.localResourcesBusy();
        int resourcesFree = this.allLocalResources() - resourcesBusy;
        logger.debug((Object)("---------> Resources needed :" + resourcesNeeded));
        logger.debug((Object)("---------> Resources busy   :" + resourcesBusy));
        if (resourcesNeeded == 0 || resourcesFree < resourcesNeeded) {
            return 0;
        }
        busyLocalResources.put(agentId, resourcesNeeded);
        return resourcesNeeded;
    }

    public synchronized void cleanLocalResourcesComputational(String genId) {
        logger.debug((Object)(" ---------- Resources clean up called ----" + busyLocalResources));
        busyLocalResources.remove(genId);
        logger.debug((Object)(" ---------- Resources busy " + busyLocalResources));
    }

    public synchronized int getLocalResourcesFree() {
        return this.allLocalResources() - this.localResourcesBusy();
    }

    public static String getConfigPath() {
        return ServiceContext.getContext().getProperty("configDir", new boolean[0]) + "/cfg/";
    }

    public List<StatisticalType> getListParameters(String category, String algorithmName) throws Exception {
        switch (AlgorithmCategory.valueOf(category)) {
            case DISTRIBUTIONS: {
                return GeneratorsFactory.getAlgorithmParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case EVALUATORS: {
                return EvaluatorsFactory.getEvaluatorParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case MODELS: {
                return ModelersFactory.getModelParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case TRANSDUCERS: {
                return TransducerersFactory.getTransducerParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case CLUSTERERS: {
                return ClusterersFactory.getClustererParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
        }
        throw new Exception();
    }

    public String getAgorithmDescription(String category, String algorithmName) throws Exception {
        switch (AlgorithmCategory.valueOf(category)) {
            case DISTRIBUTIONS: {
                return GeneratorsFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case EVALUATORS: {
                return EvaluatorsFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case MODELS: {
                return ModelersFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case TRANSDUCERS: {
                return TransducerersFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case CLUSTERERS: {
                return ClusterersFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
        }
        throw new Exception();
    }

    public synchronized boolean setD4ScienceComputation() {
        if (D4SCIENCE_COMPUTATIONS < 2) {
            ++D4SCIENCE_COMPUTATIONS;
            return true;
        }
        return false;
    }

    public synchronized void cleanD4ScienceComputation() {
        --D4SCIENCE_COMPUTATIONS;
    }

    public synchronized boolean getLocalComputation() {
        if (LOCAL_COMPUTATIONS < 3) {
            ++LOCAL_COMPUTATIONS;
            return true;
        }
        return false;
    }

    public synchronized void cleanLocalComputation() {
        --LOCAL_COMPUTATIONS;
    }
}

