/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.cache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.genericresources.GenericRGenerator;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;

public class Caching
implements Runnable {
    private static List<String> cachingAlg;
    public int running = 0;
    GCUBELog logger = new GCUBELog(ComputationFactory.class);

    public HashMap<String, List<String>> get(HashMap<String, List<String>> mapCfgAlg) {
        this.logger.debug((Object)"Inside get from file");
        HashMap<String, List<String>> resuts = new HashMap<String, List<String>>();
        try {
            cachingAlg = this.readFile();
        }
        catch (Exception e) {
            return mapCfgAlg;
        }
        block2: for (String alg : cachingAlg) {
            for (Map.Entry<String, List<String>> entry : mapCfgAlg.entrySet()) {
                if (!entry.getValue().contains(alg)) continue;
                this.logger.debug((Object)"Inside get from file");
                String key = entry.getKey();
                this.logger.debug((Object)("return :" + alg));
                resuts.put(key, entry.getValue());
                continue block2;
            }
        }
        return resuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            this.logger.debug((Object)"inside run");
            String scope = ScopeProvider.instance.get();
            String configPath = ComputationFactoryResource.getConfigPath();
            try {
                HashMap mapFeatures = ProcessorsFactory.getAllFeaturesUser((String)configPath);
                HashMap<SMAlgorithm, List<StatisticalType>> algorithmsForGrUpdate = new HashMap<SMAlgorithm, List<StatisticalType>>();
                for (Map.Entry entry : mapFeatures.entrySet()) {
                    ArrayList algorithms = new ArrayList();
                    for (String algorithmName : (List)entry.getValue()) {
                        String algorithmCategory = ServiceUtil.getAlgorithmCategory(algorithmName);
                        List<StatisticalType> parameters = ComputationFactory.getFactoryResource().getListParameters(algorithmCategory, algorithmName);
                        String description = ComputationFactory.getFactoryResource().getAgorithmDescription(algorithmCategory, algorithmName);
                        algorithmsForGrUpdate.put(new SMAlgorithm(algorithmCategory, description, algorithmName), parameters);
                    }
                }
                GenericRGenerator gr = new GenericRGenerator();
                try {
                    this.logger.debug((Object)"update file");
                    this.updateLocalFile(gr.getGenericResources());
                    this.logger.debug((Object)"call publish :");
                    gr.publishGRNew(algorithmsForGrUpdate);
                    continue;
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    this.logger.debug((Object)sw.toString());
                    ex.printStackTrace();
                    continue;
                }
                finally {
                    Thread.sleep(600000L);
                    continue;
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                this.logger.debug((Object)sw.toString());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public List<String> readFile() throws IOException {
        this.logger.debug((Object)"inside readFile");
        String fileName = ServiceContext.getContext().getProperty("configDir", new boolean[0]) + "/caching.txt";
        ArrayList<String> listAlg = new ArrayList<String>();
        File file = new File(fileName);
        BufferedReader output = new BufferedReader(new FileReader(file));
        String sCurrentLine = new String();
        while ((sCurrentLine = output.readLine()) != null) {
            this.logger.debug((Object)sCurrentLine);
            listAlg.add(sCurrentLine);
        }
        output.close();
        return listAlg;
    }

    public synchronized void updateLocalFile(List<String> algorithmList) throws IOException {
        String fileName = ServiceContext.getContext().getProperty("configDir", new boolean[0]) + "/caching.txt";
        this.logger.debug((Object)"inside updateLocalFile");
        File file = new File(fileName);
        BufferedWriter output = new BufferedWriter(new FileWriter(file, false));
        for (String algorithm : algorithmList) {
            output.write(algorithm);
            output.newLine();
        }
        output.close();
        this.logger.debug((Object)"outside updateLocalFile");
    }
}

