/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.experimentspace.genericresources.GenericRGenerator;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTypeParameter;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;

public class ServiceUtil {
    private static GCUBELog logger = new GCUBELog(ServiceUtil.class);

    private static boolean isGenericResourceInScope(List<String> rtrs, String name) {
        return rtrs.contains(name);
    }

    private static List<String> getScpeResources(String scope) throws Exception {
        ArrayList<String> algNames = new ArrayList<String>();
        String queryString = "for $resource in collection('/db/Profiles/GenericResource')//Resource where ($resource/Profile/SecondaryType eq 'StatisticalManagerAlgorithm') and ($resource/Scopes/Scope eq '" + scope + "') return $resource/Profile/Name/text()";
        logger.debug((Object)queryString);
        QueryBox q = new QueryBox(queryString);
        DiscoveryClient client = ICFactory.client();
        algNames.addAll(client.submit((Query)q));
        int size = algNames.size();
        logger.debug((Object)("Size gr found :" + size));
        return algNames;
    }

    public static SMListGroupedAlgorithms getGroupedAlgorithm(SMTypeParameter[] param, HashMap<String, List<String>> mapFeatures) throws Exception {
        String callScope = ScopeProvider.instance.get();
        List<String> grs = ServiceUtil.getScpeResources(callScope);
        ArrayList<SMGroupedAlgorithms> features = new ArrayList<SMGroupedAlgorithms>();
        HashMap<SMAlgorithm, List<StatisticalType>> algorithmsForGrUpdate = new HashMap<SMAlgorithm, List<StatisticalType>>();
        for (Map.Entry<String, List<String>> entry : mapFeatures.entrySet()) {
            SMGroupedAlgorithms feature = new SMGroupedAlgorithms();
            feature.setCategory(entry.getKey());
            ArrayList<SMAlgorithm> algorithms = new ArrayList<SMAlgorithm>();
            for (String algorithmName : entry.getValue()) {
                String algorithmCategory = ServiceUtil.getAlgorithmCategory(algorithmName);
                logger.debug((Object)("Computer category " + algorithmCategory));
                List<StatisticalType> parameters = ComputationFactory.getFactoryResource().getListParameters(algorithmCategory, algorithmName);
                String description = ComputationFactory.getFactoryResource().getAgorithmDescription(algorithmCategory, algorithmName);
                algorithmsForGrUpdate.put(new SMAlgorithm(algorithmCategory, description, algorithmName), parameters);
                if (!ServiceUtil.isGenericResourceInScope(grs, algorithmName)) continue;
                logger.debug((Object)("Add algorithm :" + algorithmName));
                if (param == null || param.length == 0) {
                    algorithms.add(new SMAlgorithm(algorithmCategory, description, algorithmName));
                    continue;
                }
                for (SMTypeParameter typeParameter : param) {
                    if (!FactoryComputationParameter.containParameter(typeParameter, parameters)) continue;
                    algorithms.add(new SMAlgorithm(algorithmCategory, description, algorithmName));
                }
            }
            if (algorithms.isEmpty()) continue;
            feature.setList(algorithms.toArray(new SMAlgorithm[algorithms.size()]));
            features.add(feature);
        }
        logger.debug((Object)"Call gr publish ");
        GenericRGenerator gr = new GenericRGenerator();
        gr.publishGRNew(algorithmsForGrUpdate);
        ScopeProvider.instance.set(callScope);
        return new SMListGroupedAlgorithms(features.toArray(new SMGroupedAlgorithms[features.size()]));
    }

    public static String getAlgorithmCategory(String algorithmUser) throws Exception {
        String configPath = ComputationFactoryResource.getConfigPath();
        HashMap mapFeatures = ProcessorsFactory.getAllFeatures((String)configPath);
        for (Map.Entry entry : mapFeatures.entrySet()) {
            List algorithms = (List)entry.getValue();
            for (String algorithm : algorithms) {
                if (!algorithm.equals(algorithmUser)) continue;
                return (String)entry.getKey();
            }
        }
        throw new Exception("Computation agent category not found");
    }

    public static WorkspaceFolder getWorkspaceSMFolder(String userName) throws WorkspaceFolderNotFoundException, InternalErrorException, HomeNotFoundException, UserNotFoundException {
        WorkspaceFolder appfolder = null;
        try {
            logger.debug((Object)("get Workspace Application Folder for the user " + userName));
            Home home = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(userName);
            logger.debug((Object)"get home");
            appfolder = home.getDataArea().getApplicationRoot("StatisticalManager");
            logger.debug((Object)"foldere created");
        }
        catch (Exception e) {
            logger.debug((Object)"Exception");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logger.debug((Object)sw.toString());
            logger.debug((Object)pw.toString());
            logger.debug((Object)e.toString());
            e.printStackTrace();
        }
        return appfolder;
    }

    public static String getDateTime() {
        Calendar currentDate = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("dd MM yyyy HH_mm_ss");
        String dateNow = formatter.format(currentDate.getTime());
        return dateNow;
    }
}

